# 联合模式

GoToSocial 当前提供“黑名单”和“白名单”联合模式，可以通过在 `config.yaml` 中设置 `instance-federation-mode`，或者使用环境变量 `GTS_INSTANCE_FEDERATION_MODE` 来配置。这些模式如下所述。

## 黑名单联合模式（默认）

当 `instance-federation-mode` 设置为 `blocklist` 时，你的实例将与其他实例自由联合，没有限制，但你在设置面板中明确创建的屏蔽的实例除外。

当你的实例收到来自不在黑名单内的实例的新请求时，如果请求有效，并且请求者被允许查看所请求的资源（考虑贴文的可见性和任何用户级屏蔽），实例将处理该请求。

当你的实例遇到它以前未见过的贴文或账户的提及或公告时，如果该资源的域未通过域屏蔽条目被屏蔽，它将会去获取该资源。

!!! info "附注"
    黑名单联合模式是 GoToSocial 的默认联合模式。它也是大多数其他 ActivityPub 服务器实现的默认联合模式。

## 白名单联合模式

!!! warning "警告"
    白名单联合模式仍然被认为是“实验性”的，我们正在研究其在实际中的表现。它应该如其名称所示，但可能会在其他地方导致错误或出现边缘情况，我们还不确定！

当 `instance-federation-mode` 设置为 `allowlist` 时，你的实例将仅与通过设置面板明确设为允许的实例联合，并限制任何未被允许的实例的访问。

当你的实例收到来自白名单之外实例的新请求时，它将拒绝处理该请求。如果请求来自白名单中的域名，你的实例将处理该请求（考虑贴文的可见性和任何用户级别的屏蔽）。

当你的实例遇到它以前未见过的贴文或账户的提及或公告时，它只会在资源所属域名被明确允许时才去获取资源。

!!! tip "提示"
    白名单联合模式在你希望仅与选择的“可信”实例联合的情况下非常有用。然而，这会影响发现过程。在黑名单联合模式下，你会通过转发和回复自然地遇到未知实例的贴文和账户，但在白名单联合模式下，这样的偶然发现不会发生。
    
    因此，建议你要么先从黑名单联合模式开始，然后在确定喜欢哪些其他实例后切换到白名单联合模式，要么从白名单联合模式开始，并在首次启动实例后准备好并导入白名单，以便“启动”它。

## 结合屏蔽与允许

可以同时屏蔽和允许同一个域，结合这两者的效果取决于你的实例当前使用的联合模式。

![一个流程图，显示两种不同联合模式如何处理传入的请求。](../public/diagrams/federation_modes.png)

### 在黑名单模式下

如图所示，在黑名单模式下（图的左侧），显式添加允许条目可以用来覆盖域名屏蔽。

这在你从其他人处导入黑名单，但导入的黑名单中包含了一些你实际上不想屏蔽的实例时很有用。为了避免屏蔽这些实例，你可以先为这些实例显式创建允许条目。然后，当你导入黑名单时，显式允许的域将不会被屏蔽，并且创建屏蔽所导致的副作用（删除贴文、媒体、关系等）将不会被处理。

如果你以后移除对于同时存在屏蔽的域的显式允许，该实例将被屏蔽，并且将处理屏蔽创建的相关影响。

相反，如果你为被屏蔽的域添加显式允许，将处理解除屏蔽的相关影响。

### 在白名单模式下

如图所示，在白名单模式下（图的右侧），显式域名屏蔽条目会优先于显式域名允许条目。在运行白名单模式时，必须满足以下两个条件才能允许一个实例通过：

1. 实例没有存在对应的显式域名屏蔽。
2. 实例存在对应的显式域名允许。

如果上述任何条件不满足，请求将被拒绝。

!!! danger "危险"
    结合屏蔽和允许是一项棘手的工作！
    
    在导入允许和黑名单时，你应该始终手动审核列表，以确保不会无意中屏蔽你不想屏蔽的实例，因为这可能会有**非常烦人的副作用**，例如移除关注/被关注、贴文等。
    
    有疑问时，请始终首先添加显式允许作为保险策略！
