# 新账户注册

如果你希望你的实例不仅限于你自己，还可以让其他人注册账户，你可以开放你的实例供新账户注册。

注意，作为实例管理员，无论你是否愿意，你都需对在你的实例上发布的内容负责。如果你的实例用户在联合网上骚扰或烦扰他人，可能会导致你的实例名誉受损，并被其他人屏蔽。妥善管理一个社区需要付出努力。因此，你应仔细考虑是否愿意且有能力进行管理，及是否只接受朋友和你非常信任的人注册账户。

!!! warning "警告"
    为使注册流程正常运作，你的实例应[配置电子邮件发件服务](../configuration/smtp.md)。

    如下所述，在注册流程中，会向你（作为管理员/站务）和申请人发送几封邮件，包括要求对方确认邮箱地址的邮件。

    如果他们无法收到此邮件（因为你的实例未配置电子邮件发件服务），你将需要通过[使用 CLI 工具](../admin/cli.md#gotosocial-admin-account-confirm)手动确认账户。

## 开放注册

你可以通过在[配置文件](../configuration/accounts.md)中将变量 `accounts-registration-open` 修改为 `true`，并重启你的 GoToSocial 实例来开放新账户注册。

你的实例将会在 `/signup` 端点提供注册表单。例如，`https://your-instance.example.org/signup`。

![注册表单，显示电子邮件、密码、用户名和理由字段。](../public/signup-form.png)

此外，你的实例主页和“关于”页面将更新，以反映注册现已开放。

当有人提交新注册申请时，他们会在提供的电子邮件地址收到一封邮件，其中包含一个链接，用于确认该地址确实属于他们。

同时，你实例上的管理员和站务会收到一封邮件和一条通知，告知有新的注册申请提交。

## 处理注册

实例管理员和版主可以通过管理面板中的“账户” -> “待处理”部分来审批或拒绝新注册。

![管理员设置面板打开到“账户” -> “待处理”，显示列表中有一个账户。](../public/signup-pending.png)

如果没有注册申请，以上列表将为空。如果有待处理的注册申请，你可以点击打开账户详情页：

![新待处理账户详情，提供批准或拒绝注册的选项。](../public/signup-account.png)

在底部，你会看到批准或拒绝注册的操作选项。

如果你**批准**注册，账户将被标记为“已批准”，并会向申请人发送一封邮件，通知其注册已获批准，并提醒他们确认电子邮件地址（如果尚未确认）。如果已经确认，他们就可以登录并开始使用他们的账户。

如果你**拒绝**注册，可以选择通知申请人注册被拒，你可以通过勾选“发送邮件”复选框来实现。这将向申请人发送一封简短邮件，告知其被拒。如果需要，还可以添加自定义消息，该消息将添加在邮件底部。你还可以添加仅供其他管理员查看的私人备注。

!!! warning "警告"
    你可能希望等申请人确认他们的电子邮件地址后再批准注册，以防申请时输入错误或提供不是他们的电子邮件地址。如果他们不能确认电子邮件地址，将无法登录和使用账户。

## 注册限制

为了避免积压的注册申请超出管理员和版主的处理能力，GoToSocial 默认将待处理注册积压限制为 20 个账号。一旦待处理队列中有 20 个账号等待管理员或版主处理，将不再通过表单接受新注册申请。

默认情况下，如果在过去 24 小时内已批准的注册账号数达到或超过 10 个，新注册也将不再通过表单接受，以避免实例规模快速扩张超出管理能力。

在这两种情况下，申请者将看到一条错误信息，说明无法提交表单的原因，并邀请他们稍后再试。

每日注册的上限及待处理注册队列的大小可以通过 `accounts-registration-daily-limit` 和 `accounts-registration-backlog-limit` 这两个变量进行配置或完全禁用。更多信息请参见 [账户配置](../configuration/accounts.md)。

为了防止垃圾账户，GoToSocial 的账户注册**始终**需要管理员手动审批，并且申请人**始终**需确认其电子邮件地址后才能登录和发布贴文。

## 通过邀请注册

尚未实现: 在未来的更新中，管理员和版主将能够创建和发送邀请，即使公共注册关闭时也允许创建账户，并可预先批准通过邀请创建的账户，和/或允许其绕过上述注册限制。
