# Installer for Intel Hardware Accelerated Execution Manager

This software is the HAXM setup program, which is used to install and load the
HAXM kernel driver, and start the corresponding service for VM (virtual machine)
application use. It supports installation, upgrade and uninstallation
operations, and provides two modes of GUI (graphical user interface) wizard and
silent installation. It can be executed as a standalone installer or as an
extension of **Android SDK Tools** in **Android Studio**. This software
currently only supports running on Windows.

The installer has the built-in **Check Tool**, which is used to check the system
environment before installing or uninstalling HAXM.

## Downloads

Since HAXM release v7.6.5, the installer had used this new framework. The
installer is available in the latest [HAXM release][haxm-release] for Windows.

## Usage

### GUI mode

Execute _haxm-\<version>-setup.exe_ extracted from the release package.
Following the setup wizard to complete HAXM installation.

### Silent mode

1. `cd X:\path\to\haxm-windows_<version>`
1. `silent_install.bat`

The output will be as below if successful.

    Intel HAXM installed successfully!

## Build

### Prerequisites

[NSIS][nsis] (Nullsoft Scriptable Install System) 3.05 or later

Install the following components:

Header Files       | |
------------------ | -------------------------------------------
Explode.nsh        | <https://nsis.sourceforge.io/Explode>
StrStr.nsh         | <https://nsis.sourceforge.io/StrStr>
**Plug-ins**       |
[ExecDos][execdos] | <https://nsis.sourceforge.io/ExecDos_plug-in>
[LogEx][logex]     | <https://nsis.sourceforge.io/LogEx_plug-in>

**Header Files**

Save the **Function code** in above URLs as .nsh files, and insert the following
code in the header of each file:

`!include "LogicLib.nsh"`

Copy these header files to the system _Include_ folder, e.g.,
_C:\Program Files (x86)\NSIS\Include\\_

**Plug-ins**

Download and extract zip packages to NSIS installation path, e.g.,
_C:\Program Files (x86)\NSIS\\_. Then move the extracted library
_C:\Program Files (x86)\NSIS\Plugins\Unicode\LogEx.dll_ to the folder
_C:\Program Files (x86)\NSIS\Plugins\x86-unicode\\_.

If you do not intend to extract the whole plug-in packages to NSIS installation
path, you can first extract the plug-in packages to the current directory, and
then only copy the libraries to the system _Plugins_ folder. Run below command
in an **elevated** Command Prompt:

`cp .\Plugins\x86-unicode\ExecDos.dll .\Plugins\Unicode\LogEx.dll
"C:\Program Files (x86)\NSIS\Plugins\x86-unicode"`

### Build steps

#### Prepare components

Prepare _assets_ folder in _Installer_ folder as below.

    assets
    ├── checktool.exe            Copied from the build output of "Check Tool"
    ├── LICENSE                  Copied from the 'LICENSE' file of HAXM
    ├── uninstall.exe            Generated by executing 'uninstall-maker.exe'
    ├── uninstall-maker.exe      Generated by compiling 'Uninstall.nsi'
    ├── win10
    │   ├── x64
    │   │   └── IntelHaxm.sys    Copied from the 64-bit build output of HAXM,
    │   │                        e.g., 'platforms\windows\build\out\x64\Debug'
    │   └── x86
    │       └── IntelHaxm.sys    Copied from the 32-bit build output of HAXM,
    │                            e.g., 'platforms\windows\build\out\Win32\Debug'
    └── win7
        ├── x64
        │   └── IntelHaxm.sys    Copied from the 64-bit build output of HAXM,
        │                        e.g., 'platforms\windows\build\out\x64\Debug'
        └── x86
            └── IntelHaxm.sys    Copied from the 32-bit build output of HAXM,
                                 e.g., 'platforms\windows\build\out\Win32\Debug'

1. Build HAXM

   Follow this [manual][manual-windows] to build the 32-/64-bit HAXM drivers and
place them in the corresponding paths above. The difference between the folders
_win10_ and _win7_ is: the signing approaches of the release drivers are
different. The kernel drivers for Windows 10 are signed by Microsoft online,
while drivers for other versions of Windows are signed by SignTool offline.

   If the HAXM drivers are built with Debug configuration, both are signed with
test certificate. In this case, the drivers in the folders _win10_ and _win7_
can be kept consistent.

1. Build Check Tool

   Follow this [link][checktool-readme] to build Check Tool executable and place
it in the corresponding path above. User can decide the build configuration
according to the bits of the target platform.

1. Build uninstaller

   Right click _Uninstall.nsi_ > **Compile NSIS Script**, then
_uninstall-maker.exe_ will be generated in _assets_ folder. After executing
_uninstall-maker.exe_, the uninstaller _uninstall.exe_ will be generated
alongside.

#### Build installer

Right click _HaxmSetup.nsi_ > **Compile NSIS Script**, then the installer
_haxm-\<version>-setup.exe_ will be built out in the current directory.

So far, there is only 32-bit Windows release for NSIS, therefore only the 32-bit
Windows installer can be generated. It can be installed on both 32-bit and
64-bit Windows platforms.

[checktool-readme]:
https://github.com/intel/haxm/blob/master/CheckTool/README.md
[execdos]: https://nsis.sourceforge.io/mediawiki/images/0/0f/ExecDos.zip
[haxm-release]: https://github.com/intel/haxm/releases
[logex]: https://nsis.sourceforge.io/mediawiki/images/d/d1/LogEx.zip
[manual-windows]:
https://github.com/intel/haxm/blob/master/docs/manual-windows.md
[nsis]: https://nsis.sourceforge.io/Download
