// NOTE: Good example to look at:
// https://github.com/rust-lang/rust-analyzer/tree/master/xtask

use std::env;
use std::path::{Path, PathBuf};

use clap::{Parser, Subcommand};

mod gen;

#[derive(Parser)]
struct Cli {
    #[command(subcommand)]
    command: Commands,
}

#[derive(Subcommand)]
enum Commands {
    /// Generate shell completions to `completions` dir
    Gen,
}

fn main() {
    let Cli { command } = Cli::parse();

    env::set_current_dir(project_root()).unwrap();

    match command {
        Commands::Gen => gen::gen(),
    }
}

fn project_root() -> PathBuf {
    Path::new(
        &env::var("CARGO_MANIFEST_DIR").unwrap_or_else(|_| env!("CARGO_MANIFEST_DIR").to_owned()),
    )
    .ancestors()
    .nth(1)
    .unwrap()
    .to_path_buf()
}
