
set(SDL2_PATH "" CACHE STRING "SDL2 path")

if(CMAKE_SIZEOF_VOID_P EQUAL 8)
	set(SDL2_LIB_PATH lib64)
else()
	set(SDL2_LIB_PATH lib)
endif()

find_path(SDL2_INCLUDE_DIR SDL.h
	PATH_SUFFIXES include
	PATHS ${SDL2_PATH} "${CMAKE_CURRENT_SOURCE_DIR}/Windows/SDL2")

set(SDL2_INCLUDE_DIRS "${SDL2_INCLUDE_DIR}")

find_library(SDL2_LIBRARY
	NAMES SDL2
	PATH_SUFFIXES ${SDL2_LIB_PATH}
	PATHS ${SDL2_PATH} "${CMAKE_CURRENT_SOURCE_DIR}/Windows/SDL2")

find_library(SDL2_MAIN_LIBRARY
	NAMES SDL2main
	PATH_SUFFIXES ${SDL2_LIB_PATH}
	PATHS ${SDL2_PATH} "${CMAKE_CURRENT_SOURCE_DIR}/Windows/SDL2")

find_file(SDL2_DLL
	NAMES SDL2.dll
	PATH_SUFFIXES ${SDL2_LIB_PATH}
	PATHS ${SDL2_PATH} "${CMAKE_CURRENT_SOURCE_DIR}/Windows/SDL2")

set(SDL2_LIBRARIES "${SDL2_LIBRARY}" "${SDL2_MAIN_LIBRARY}")

if (SDL2_INCLUDE_DIR AND EXISTS "${SDL2_INCLUDE_DIR}/SDL_version.h")
	file(STRINGS "${SDL2_INCLUDE_DIR}/SDL_version.h" SDL2_VERSION_MAJOR_LINE REGEX "^#define[ \t]+SDL_MAJOR_VERSION[ \t]+[0-9]+$")
	file(STRINGS "${SDL2_INCLUDE_DIR}/SDL_version.h" SDL2_VERSION_MINOR_LINE REGEX "^#define[ \t]+SDL_MINOR_VERSION[ \t]+[0-9]+$")
	file(STRINGS "${SDL2_INCLUDE_DIR}/SDL_version.h" SDL2_VERSION_PATCH_LINE REGEX "^#define[ \t]+SDL_PATCHLEVEL[ \t]+[0-9]+$")
	string(REGEX REPLACE "^#define[ \t]+SDL_MAJOR_VERSION[ \t]+([0-9]+)$" "\\1" SDL2_VERSION_MAJOR "${SDL2_VERSION_MAJOR_LINE}")
	string(REGEX REPLACE "^#define[ \t]+SDL_MINOR_VERSION[ \t]+([0-9]+)$" "\\1" SDL2_VERSION_MINOR "${SDL2_VERSION_MINOR_LINE}")
	string(REGEX REPLACE "^#define[ \t]+SDL_PATCHLEVEL[ \t]+([0-9]+)$" "\\1" SDL2_VERSION_PATCH "${SDL2_VERSION_PATCH_LINE}")
	set(SDL2_VERSION_STRING ${SDL2_VERSION_MAJOR}.${SDL2_VERSION_MINOR}.${SDL2_VERSION_PATCH})
	unset(SDL2_VERSION_MAJOR_LINE)
	unset(SDL2_VERSION_MINOR_LINE)
	unset(SDL2_VERSION_PATCH_LINE)
	unset(SDL2_VERSION_MAJOR)
	unset(SDL2_VERSION_MINOR)
	unset(SDL2_VERSION_PATCH)
endif()

include(FindPackageHandleStandardArgs)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(SDL2 REQUIRED_VARS SDL2_LIBRARY SDL2_INCLUDE_DIR VERSION_VAR SDL2_VERSION_STRING)

if (SDL2_FOUND)
	if (SDL2_LIBRARY)
		add_library(SDL2::SDL2 SHARED IMPORTED GLOBAL)
		set_target_properties(SDL2::SDL2 PROPERTIES IMPORTED_IMPLIB "${SDL2_LIBRARY}" IMPORTED_LOCATION "${SDL2_DLL}" INTERFACE_INCLUDE_DIRECTORIES "${SDL2_INCLUDE_DIR}")

		if (SDL2_MAIN_LIBRARY)
			add_library(SDL2::main UNKNOWN IMPORTED)
			set_target_properties(SDL2::main PROPERTIES IMPORTED_LOCATION "${SDL2_MAIN_LIBRARY}")
			if (NOT MINGW)
				set_property(TARGET SDL2::SDL2 APPEND PROPERTY INTERFACE_LINK_LIBRARIES SDL2::main)
			endif()
		endif()
	endif()
endif()