/*
 * Copyright (c) 2015, 2021, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.internal.module;

import java.lang.module.ModuleDescriptor;
import java.util.Map;
import java.util.Set;

/**
 * A SystemModules object reconstitutes module descriptors and other modules
 * attributes in an efficient way to avoid parsing module-info.class files at
 * startup. Implementations of this class are generated by the "system modules"
 * jlink plugin.
 *
 * @see SystemModuleFinders
 * @see jdk.tools.jlink.internal.plugins.SystemModulesPlugin
 */

interface SystemModules {

    /**
     * Returns false if the module reconstituted by this SystemModules object
     * have no overlapping packages. Returns true if there are overlapping
     * packages or unknown.
     */
    boolean hasSplitPackages();

    /**
     * Return false if the modules reconstituted by this SystemModules object
     * do not include any incubator modules. Returns true if there are
     * incubating modules or unknown.
     */
    boolean hasIncubatorModules();

    /**
     * Returns the non-empty array of ModuleDescriptor objects.
     */
    ModuleDescriptor[] moduleDescriptors();

    /**
     * Returns the array of ModuleTarget objects. The array elements correspond
     * to the array of ModuleDescriptor objects.
     */
    ModuleTarget[] moduleTargets();

    /**
     * Returns the array of ModuleHashes objects. The array elements correspond
     * to the array of ModuleDescriptor objects.
     */
    ModuleHashes[] moduleHashes();

    /**
     * Returns the array of ModuleResolution objects. The array elements correspond
     * to the array of ModuleDescriptor objects.
     */
    ModuleResolution[] moduleResolutions();

    /**
     * Returns the map representing readability graph for the modules reconstituted
     * by this SystemModules object.
     */
    Map<String, Set<String>> moduleReads();
}
