const OPCODE_MNEMONICS: [&str; 256] = [
    "NOP",
    "LD BC, nn",
    "LD (BC), A",
    "INC BC",
    "INC B",
    "DEC B",
    "LD B, n",
    "RLCA",
    "EX AF, AF'",
    "ADD HL, BC",
    "LD A, (BC)",
    "DEC BC",
    "INC C",
    "DEC C",
    "LD C, n",
    "RRCA",
    "DJNZ d",
    "LD DE, nn",
    "LD (DE), A",
    "INC DE",
    "INC D",
    "DEC D",
    "LD D, n",
    "RLA",
    "JR d",
    "ADD HL, DE",
    "LD A, (DE)",
    "DEC DE",
    "INC E",
    "DEC E",
    "LD E, n",
    "RRA",
    "JR NZ, d",
    "LD HL, nn",
    "LD (nn), HL",
    "INC HL",
    "INC H",
    "DEC H",
    "LD H, n",
    "DAA",
    "JR Z, d",
    "ADD HL, HL",
    "LD HL, (nn)",
    "DEC HL",
    "INC L",
    "DEC L",
    "LD L, n",
    "CPL",
    "JR NC, d",
    "LD SP, nn",
    "LD (nn), A",
    "INC SP",
    "INC (HL)",
    "DEC (HL)",
    "LD (HL), n",
    "SCF",
    "JR C, d",
    "ADD HL, SP",
    "LD A, (nn)",
    "DEC SP",
    "INC A",
    "DEC A",
    "LD A, n",
    "CCF",
    "LD B, B",
    "LD B, C",
    "LD B, D",
    "LD B, E",
    "LD B, H",
    "LD B, L",
    "LD B, (HL)",
    "LD B, A",
    "LD C, B",
    "LD C, C",
    "LD C, D",
    "LD C, E",
    "LD C, H",
    "LD C, L",
    "LD C, (HL)",
    "LD C, A",
    "LD D, B",
    "LD D, C",
    "LD D, D",
    "LD D, E",
    "LD D, H",
    "LD D, L",
    "LD D, (HL)",
    "LD D, A",
    "LD E, B",
    "LD E, C",
    "LD E, D",
    "LD E, E",
    "LD E, H",
    "LD E, L",
    "LD E, (HL)",
    "LD E, A",
    "LD H, B",
    "LD H, C",
    "LD H, D",
    "LD H, E",
    "LD H, H",
    "LD H, L",
    "LD H, (HL)",
    "LD H, A",
    "LD L, B",
    "LD L, C",
    "LD L, D",
    "LD L, E",
    "LD L, H",
    "LD L, L",
    "LD L, (HL)",
    "LD L, A",
    "LD (HL), B",
    "LD (HL), C",
    "LD (HL), D",
    "LD (HL), E",
    "LD (HL), H",
    "LD (HL), L",
    "HALT",
    "LD (HL), A",
    "LD A, B",
    "LD A, C",
    "LD A, D",
    "LD A, E",
    "LD A, H",
    "LD A, L",
    "LD A, (HL)",
    "LD A, A",
    "ADD A, B",
    "ADD A, C",
    "ADD A, D",
    "ADD A, E",
    "ADD A, H",
    "ADD A, L",
    "ADD A, (HL)",
    "ADD A, A",
    "ADC A, B",
    "ADC A, C",
    "ADC A, D",
    "ADC A, E",
    "ADC A, H",
    "ADC A, L",
    "ADC A, (HL)",
    "ADC A, A",
    "SUB B",
    "SUB C",
    "SUB D",
    "SUB E",
    "SUB H",
    "SUB L",
    "SUB (HL)",
    "SUB A",
    "SBC A, B",
    "SBC A, C",
    "SBC A, D",
    "SBC A, E",
    "SBC A, H",
    "SBC A, L",
    "SBC A, (HL)",
    "SBC A, A",
    "AND B",
    "AND C",
    "AND D",
    "AND E",
    "AND H",
    "AND L",
    "AND (HL)",
    "AND A",
    "XOR B",
    "XOR C",
    "XOR D",
    "XOR E",
    "XOR H",
    "XOR L",
    "XOR (HL)",
    "XOR A",
    "OR B",
    "OR C",
    "OR D",
    "OR E",
    "OR H",
    "OR L",
    "OR (HL)",
    "OR A",
    "CP B",
    "CP C",
    "CP D",
    "CP E",
    "CP H",
    "CP L",
    "CP (HL)",
    "CP A",
    "RET NZ",
    "POP BC",
    "JP NZ, nn",
    "JP nn",
    "CALL NZ, nn",
    "PUSH BC",
    "ADD A, n",
    "RST $00",
    "RET Z",
    "RET",
    "JP Z, nn",
    "(bit prefix)",
    "CALL Z, nn",
    "CALL nn",
    "ADC A, n",
    "RST $08",
    "RET NC",
    "POP DE",
    "JP NC, nn",
    "OUT (n), A",
    "CALL NC, nn",
    "PUSH DE",
    "SUB n",
    "RST $10",
    "RET C",
    "EXX",
    "JP C, nn",
    "IN A, (n)",
    "CALL C, nn",
    "(IX prefix)",
    "SBC A, n",
    "RST $18",
    "RET PO",
    "POP HL",
    "JP PO, nn",
    "EX (SP), HL",
    "CALL PO, nn",
    "PUSH HL",
    "AND n",
    "RST $20",
    "RET PE",
    "JP (HL)",
    "JP PE, nn",
    "EX DE, HL",
    "CALL PE, nn",
    "(ED prefix)",
    "XOR n",
    "RST $28",
    "RET P",
    "POP AF",
    "JP P, nn",
    "DI",
    "CALL P, nn",
    "PUSH AF",
    "OR n",
    "RST $30",
    "RET M",
    "LD SP, HL",
    "JP M, nn",
    "EI",
    "CALL M, nn",
    "(IY prefix)",
    "CP n",
    "RST $38",
];

pub fn for_opcode(opcode: u8, next: u8) -> &'static str {
    match opcode {
        0xED => match next {
            0x40 => "IN B, (C)",
            0x41 => "OUT (C), B",
            0x42 => "SBC HL, BC",
            0x43 => "LD (nn), BC",
            0x44 => "NEG",
            0x45 => "RETN",
            0x46 => "IM 0",
            0x47 => "LD I, A",
            0x48 => "IN C, (C)",
            0x49 => "OUT (C), C",
            0x4A => "ADC HL, BC",
            0x4B => "LD BC, (nn)",
            0x4D => "RETI",
            0x4F => "LD R, A",
            0x50 => "IN D, (C)",
            0x51 => "OUT (C), D",
            0x52 => "SBC HL, DE",
            0x53 => "LD (nn), DE",
            0x56 => "IM 1",
            0x57 => "LD A, I",
            0x58 => "IN E, (C)",
            0x59 => "OUT (C), E",
            0x5A => "ADC HL, DE",
            0x5B => "LD DE, (nn)",
            0x5E => "IM 2",
            0x5F => "LD A, R",
            0x60 => "IN H, (C)",
            0x61 => "OUT (C), H",
            0x62 => "SBC HL, HL",
            0x67 => "RRD",
            0x68 => "IN L, (C)",
            0x69 => "OUT (C), L",
            0x6A => "ADC HL, HL",
            0x6F => "RLD",
            0x72 => "SBC HL, SP",
            0x73 => "LD (nn), SP",
            0x78 => "IN A, (C)",
            0x79 => "OUT (C), A",
            0x7A => "ADC HL, SP",
            0x7B => "LD SP, (nn)",
            0xA0 => "LDI",
            0xA1 => "CPI",
            0xA2 => "INI",
            0xA3 => "OUTI",
            0xA8 => "LDD",
            0xA9 => "CPD",
            0xAA => "IND",
            0xAB => "OUTD",
            0xB0 => "LDIR",
            0xB1 => "CPIR",
            0xB2 => "INIR",
            0xB3 => "OTIR",
            0xB8 => "LDDR",
            0xB9 => "CPDR",
            0xBA => "INDR",
            0xBB => "OTDR",
            _ => "unknown ED-prefixed opcode",
        },
        _ => OPCODE_MNEMONICS[opcode as usize],
    }
}
