/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatalayout.packet;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class DataLayout
implements ExtensionElement {
    public static final String ELEMENT = "page";
    public static final String NAMESPACE = "http://jabber.org/protocol/xdata-layout";
    private final List<DataFormLayoutElement> pageLayout = new ArrayList<DataFormLayoutElement>();
    private final String label;

    public DataLayout(String label) {
        this.label = label;
    }

    public List<DataFormLayoutElement> getPageLayout() {
        return this.pageLayout;
    }

    public String getLabel() {
        return this.label;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder buf = new XmlStringBuilder((ExtensionElement)this);
        buf.optAttribute("label", this.getLabel());
        buf.rightAngleBracket();
        buf.append(this.getPageLayout());
        buf.closeElement((NamedElement)this);
        return buf;
    }

    public static abstract class DataFormLayoutElement
    implements ExtensionElement {
        public final String getNamespace() {
            return DataLayout.NAMESPACE;
        }
    }

    public static class Text
    extends DataFormLayoutElement {
        public static final String ELEMENT = "text";
        private final String text;

        public Text(String text) {
            this.text = text;
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder buf = new XmlStringBuilder((FullyQualifiedElement)this, enclosingNamespace);
            buf.rightAngleBracket();
            buf.escape(this.getText());
            buf.closeElement((NamedElement)this);
            return buf;
        }

        public String getText() {
            return this.text;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Reportedref
    extends DataFormLayoutElement {
        public static final String ELEMENT = "reportedref";

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder buf = new XmlStringBuilder((FullyQualifiedElement)this, enclosingNamespace);
            buf.closeEmptyElement();
            return buf;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Section
    extends DataFormLayoutElement {
        public static final String ELEMENT = "section";
        private final List<DataFormLayoutElement> sectionLayout = new ArrayList<DataFormLayoutElement>();
        private final String label;

        public Section(String label) {
            this.label = label;
        }

        public List<DataFormLayoutElement> getSectionLayout() {
            return this.sectionLayout;
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder buf = new XmlStringBuilder((FullyQualifiedElement)this, enclosingNamespace);
            buf.optAttribute("label", this.getLabel());
            buf.rightAngleBracket();
            buf.append(this.getSectionLayout());
            buf.closeElement(ELEMENT);
            return buf;
        }

        public String getLabel() {
            return this.label;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Fieldref
    extends DataFormLayoutElement {
        public static final String ELEMENT = "fieldref";
        private final String var;

        public Fieldref(String var) {
            this.var = var;
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder buf = new XmlStringBuilder((FullyQualifiedElement)this, enclosingNamespace);
            buf.attribute("var", this.getVar());
            buf.closeEmptyElement();
            return buf;
        }

        public String getVar() {
            return this.var;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }
}

