/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem;

import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.client.core.spi.SubsystemSupport;
import org.sonatype.nexus.client.core.subsystem.Utilities;
import org.sonatype.nexus.client.rest.jersey.ContextAwareUniformInterfaceException;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;

public class JerseyUtilities
extends SubsystemSupport<JerseyNexusClient>
implements Utilities {
    public JerseyUtilities(JerseyNexusClient nexusClient) {
        super(nexusClient);
    }

    @Override
    public Date getLastModified(String uri) {
        try {
            ClientResponse response = ((JerseyNexusClient)this.getNexusClient()).uri(uri).head();
            return response.getLastModified();
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Utilities download(String path, File target) throws IOException {
        Utilities utilities;
        if (!target.exists()) {
            File targetDir = target.getParentFile();
            FileUtils.forceMkdir((File)targetDir);
        } else {
            Preconditions.checkState((target.isFile() && target.canWrite() ? 1 : 0) != 0, (String)"File '%s' is not a file or could not be written", (Object[])new Object[]{target.getAbsolutePath()});
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(target);
            utilities = this.download(path, fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return utilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Utilities download(final String path, OutputStream target) throws IOException {
        try {
            ClientResponse response = (ClientResponse)((JerseyNexusClient)this.getNexusClient()).uri(path).get(ClientResponse.class);
            if (!ClientResponse.Status.OK.equals((Object)response.getClientResponseStatus())) {
                throw ((JerseyNexusClient)this.getNexusClient()).convert(new ContextAwareUniformInterfaceException(response){

                    @Override
                    public String getMessage(int status) {
                        if (status == Response.Status.NOT_FOUND.getStatusCode()) {
                            return String.format("Inexistent path: %s", path);
                        }
                        return null;
                    }
                });
            }
            try {
                IOUtils.copy((InputStream)response.getEntityInputStream(), (OutputStream)target);
            }
            finally {
                response.close();
            }
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        return this;
    }
}

