/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.client.hc4;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.sonatype.spice.zapper.Parameters;
import org.sonatype.spice.zapper.client.hc4.Hc4Track;
import org.sonatype.spice.zapper.client.hc4.ZapperEntity;
import org.sonatype.spice.zapper.internal.Check;
import org.sonatype.spice.zapper.internal.Payload;
import org.sonatype.spice.zapper.internal.PayloadSupplier;
import org.sonatype.spice.zapper.internal.Protocol;
import org.sonatype.spice.zapper.internal.SegmentPayload;
import org.sonatype.spice.zapper.internal.Transfer;
import org.sonatype.spice.zapper.internal.transport.AbstractChargerClient;
import org.sonatype.spice.zapper.internal.transport.State;
import org.sonatype.spice.zapper.internal.transport.TrackIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hc4Client
extends AbstractChargerClient<Hc4Track> {
    private final CloseableHttpClient httpClient;
    private final CredentialsProvider preemptiveCredentialsProvider;

    public Hc4Client(Parameters parameters, String remoteUrl, CloseableHttpClient httpClient, CredentialsProvider preemptiveCredentialsProvider) {
        super(parameters, remoteUrl);
        this.httpClient = Check.notNull(httpClient, CloseableHttpClient.class);
        this.preemptiveCredentialsProvider = preemptiveCredentialsProvider;
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            this.getLogger().warn("Could not cleanly close httpClient", (Throwable)e);
        }
        super.close();
    }

    @Override
    protected Callable<State> createCallable(TrackIdentifier trackIdentifier, Transfer transfer, Protocol protocol, PayloadSupplier payloadSupplier) {
        return new Hc4Track(trackIdentifier, payloadSupplier, this);
    }

    @Override
    public State upload(Payload payload, Hc4Track track) throws IOException {
        String url = this.getRemoteUrl() + payload.getPath().stringValue();
        HttpPut put = new HttpPut(url);
        if (payload instanceof SegmentPayload) {
            put.setEntity((HttpEntity)new ZapperEntity(payload, this.getParameters().getCodecSelector().selectCodecs(((SegmentPayload)SegmentPayload.class.cast(payload)).getSegment().getZFile())));
        } else {
            put.setEntity((HttpEntity)new ZapperEntity(payload));
        }
        put.addHeader("X-Zapper-Transfer-ID", payload.getTransferIdentifier().stringValue());
        if (track != null) {
            put.addHeader("X-Zapper-Track-ID", ((TrackIdentifier)track.getIdentifier()).stringValue());
        }
        HttpClientContext context = new HttpClientContext();
        if (this.preemptiveCredentialsProvider != null) {
            context.setCredentialsProvider(this.preemptiveCredentialsProvider);
            context.setAuthCache((AuthCache)new BasicAuthCache());
            context.getAuthCache().put(new HttpHost(put.getURI().getHost(), put.getURI().getPort(), put.getURI().getScheme()), (AuthScheme)new BasicScheme());
        }
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put, (HttpContext)context);
        StatusLine statusLine = response.getStatusLine();
        EntityUtils.consume((HttpEntity)response.getEntity());
        if (statusLine.getStatusCode() <= 199 || statusLine.getStatusCode() >= 299) {
            throw new IOException(String.format("Unexpected server response: %s %s", statusLine.getStatusCode(), statusLine.getReasonPhrase()));
        }
        return State.SUCCESS;
    }

    @Override
    public State upload(Payload payload) throws IOException {
        return this.upload(payload, (Hc4Track)null);
    }
}

