/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.client.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.sonatype.sisu.siesta.client.Filters;
import org.sonatype.sisu.siesta.client.filters.RequestFilters;

public class ClientInvocationHandler
implements InvocationHandler {
    private final Class<?> serviceInterface;
    private final Client client;
    private final String baseUrl;

    public ClientInvocationHandler(Class<?> serviceInterface, Client client, String baseUrl) {
        this.serviceInterface = serviceInterface;
        this.client = client;
        try {
            this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String url = this.getUrl(method, args);
        MultivaluedMap<String, String> queryParams = this.getQueryParams(method, args);
        String httpMethod = this.getHttpMethod(method);
        String type = this.getType(method);
        String[] accepts = this.getAccepts(method);
        Object payload = this.getPayload(method, args);
        WebResource resource = this.client.resource(url);
        ClientFilter[] filters = this.getFilters(method);
        if (filters != null) {
            RequestFilters.addRequestFilters(resource.getProperties(), filters);
        }
        if (queryParams != null && !queryParams.isEmpty()) {
            resource = resource.queryParams(queryParams);
        }
        WebResource.Builder builder = resource.accept(accepts);
        if (type != null) {
            builder.type(type);
        }
        ClientResponse response = payload == null ? (ClientResponse)builder.method(httpMethod, ClientResponse.class) : (ClientResponse)builder.method(httpMethod, ClientResponse.class, payload);
        Class<?> returnType = method.getReturnType();
        if (ClientResponse.class.equals(returnType)) {
            return response;
        }
        if (Response.Status.Family.SUCCESSFUL.equals((Object)response.getClientResponseStatus().getFamily())) {
            if (!Void.TYPE.equals(returnType)) {
                return response.getEntity(new GenericType(method.getGenericReturnType()));
            }
            if (response.hasEntity()) {
                response.bufferEntity();
            }
            return null;
        }
        throw new UniformInterfaceException(response);
    }

    private MultivaluedMap<String, String> getQueryParams(Method method, Object[] args) {
        if (args != null) {
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < args.length; ++i) {
                Annotation[] annotations;
                if (args[i] == null || (annotations = parameterAnnotations[i]).length <= 0) continue;
                for (Annotation annotation : annotations) {
                    if (!(annotation instanceof QueryParam)) continue;
                    if (args[i] instanceof MultivaluedMap) {
                        MultivaluedMap map = (MultivaluedMap)args[i];
                        Set keySet = map.keySet();
                        for (Object key : keySet) {
                            for (Object value : (List)map.get(key)) {
                                if (value != null) {
                                    queryParams.add((Object)key.toString(), (Object)value.toString());
                                    continue;
                                }
                                queryParams.add((Object)key.toString(), null);
                            }
                        }
                        continue;
                    }
                    if (args[i].getClass().isArray()) {
                        for (Object entry : (Object[])args[i]) {
                            if (entry == null) continue;
                            queryParams.add((Object)((QueryParam)annotation).value(), (Object)entry.toString());
                        }
                        continue;
                    }
                    if (args[i] instanceof Iterable) {
                        for (Object entry : (Iterable)args[i]) {
                            if (entry == null) continue;
                            queryParams.add((Object)((QueryParam)annotation).value(), (Object)entry.toString());
                        }
                        continue;
                    }
                    if (args[i] instanceof Iterator) {
                        Iterator it = (Iterator)args[i];
                        while (it.hasNext()) {
                            Object entry;
                            entry = it.next();
                            if (entry == null) continue;
                            queryParams.add((Object)((QueryParam)annotation).value(), (Object)entry.toString());
                        }
                        continue;
                    }
                    queryParams.add((Object)((QueryParam)annotation).value(), (Object)args[i].toString());
                }
            }
            if (!queryParams.isEmpty()) {
                return queryParams;
            }
        }
        return null;
    }

    private Object getPayload(Method method, Object[] args) {
        if (args != null) {
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < args.length; ++i) {
                Annotation[] annotations = parameterAnnotations[i];
                if (annotations.length > 0) {
                    for (Annotation annotation : annotations) {
                        if (annotation instanceof PathParam || annotation instanceof QueryParam) continue;
                        return args[i];
                    }
                    continue;
                }
                return args[i];
            }
        }
        return null;
    }

    private String[] getAccepts(Method method) {
        Consumes consumes = method.getAnnotation(Consumes.class);
        if (consumes != null) {
            return consumes.value();
        }
        return new String[]{"application/json"};
    }

    private String getType(Method method) {
        Produces produces = method.getAnnotation(Produces.class);
        if (produces != null) {
            return produces.value()[0];
        }
        return "application/json";
    }

    private String getHttpMethod(Method method) {
        Annotation[] annotations = method.getAnnotations();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                HttpMethod httpMethod = annotation.annotationType().getAnnotation(HttpMethod.class);
                if (httpMethod == null) continue;
                return httpMethod.value();
            }
        }
        throw new IllegalStateException("Method " + method + " is not annotated with any of @GET/...");
    }

    private String getUrl(Method method, Object[] args) {
        StringBuilder rawUrl = new StringBuilder();
        Path atClass = this.serviceInterface.getAnnotation(Path.class);
        if (atClass != null) {
            rawUrl.append(atClass.value());
        } else {
            Path atDeclaringClass = method.getDeclaringClass().getAnnotation(Path.class);
            if (atDeclaringClass != null) {
                rawUrl.append(atDeclaringClass.value());
            }
        }
        Path atMethod = method.getAnnotation(Path.class);
        if (atMethod != null) {
            rawUrl.append(atMethod.value());
        }
        if (rawUrl.toString().trim().length() == 0) {
            throw new IllegalStateException(String.format("Cannot calculate rest URL for [%s]. Is class and/or method annotated with @Path?", method.getName()));
        }
        String url = rawUrl.toString();
        if (url.contains("{") && url.contains("}")) {
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Annotation[] annotations;
                if (args.length < i) continue;
                for (Annotation annotation : annotations = parameterAnnotations[i]) {
                    if (!(annotation instanceof PathParam)) continue;
                    String name = ((PathParam)annotation).value();
                    if (args[i] == null) continue;
                    url = url.replace("{" + name + "}", args[i].toString());
                }
            }
        }
        return this.baseUrl + url;
    }

    private ClientFilter[] getFilters(Method method) {
        List<ClientFilter> filters = this.getClientFilters(method.getAnnotation(Filters.class));
        if (!filters.isEmpty()) {
            return filters.toArray(new ClientFilter[filters.size()]);
        }
        filters = this.getClientFilters(method.getDeclaringClass());
        if (!filters.isEmpty()) {
            return filters.toArray(new ClientFilter[filters.size()]);
        }
        return null;
    }

    private List<ClientFilter> getClientFilters(Class<?> clazz) {
        List<ClientFilter> filters = this.getClientFilters(clazz.getAnnotation(Filters.class));
        if (!filters.isEmpty()) {
            return filters;
        }
        for (Class<?> extended : clazz.getInterfaces()) {
            List<ClientFilter> filters2 = this.getClientFilters(extended);
            if (filters2.isEmpty()) continue;
            return filters2;
        }
        return Lists.newArrayList();
    }

    private List<ClientFilter> getClientFilters(Filters annotation) {
        ArrayList filters = Lists.newArrayList();
        if (annotation != null) {
            for (Class<? extends ClientFilter> filterClass : annotation.value()) {
                try {
                    filters.add(filterClass.newInstance());
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
        return filters;
    }
}

