/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.shared.artifact.filter.StatisticsReportingArtifactFilter;
import org.slf4j.Logger;

public class PatternIncludesArtifactFilter
implements ArtifactFilter,
StatisticsReportingArtifactFilter {
    private static final String SEP = System.lineSeparator();
    private final Set<Pattern> patterns;
    private final boolean actTransitively;
    private final Set<Pattern> patternsTriggered = new HashSet<Pattern>();
    private final List<Artifact> filteredArtifact = new ArrayList<Artifact>();
    private static final String ANY = "*";
    private static final Pattern MATCH_ALL_PATTERN = new MatchAllPattern("*");

    public PatternIncludesArtifactFilter(Collection<String> patterns) {
        this(patterns, false);
    }

    public PatternIncludesArtifactFilter(Collection<String> patterns, boolean actTransitively) {
        this.actTransitively = actTransitively;
        LinkedHashSet<Pattern> pat = new LinkedHashSet<Pattern>();
        if (patterns != null && !patterns.isEmpty()) {
            for (String pattern : patterns) {
                Pattern p = PatternIncludesArtifactFilter.compile(pattern);
                pat.add(p);
            }
        }
        this.patterns = pat;
    }

    public boolean include(Artifact artifact) {
        boolean shouldInclude = this.patternMatches(artifact);
        if (!shouldInclude) {
            this.addFilteredArtifact(artifact);
        }
        return shouldInclude;
    }

    protected boolean patternMatches(Artifact artifact) {
        List depTrail;
        Boolean match = this.match(PatternIncludesArtifactFilter.adapt(artifact));
        if (match != null) {
            return match;
        }
        if (this.actTransitively && (depTrail = artifact.getDependencyTrail()) != null && depTrail.size() > 1) {
            for (String trailItem : depTrail) {
                Artifactoid artifactoid = PatternIncludesArtifactFilter.adapt(trailItem);
                match = this.match(artifactoid);
                if (match == null) continue;
                return match;
            }
        }
        return false;
    }

    private Boolean match(Artifactoid artifactoid) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matches(artifactoid)) continue;
            this.patternsTriggered.add(pattern);
            return !(pattern instanceof NegativePattern);
        }
        return null;
    }

    protected void addFilteredArtifact(Artifact artifact) {
        this.filteredArtifact.add(artifact);
    }

    @Override
    public void reportMissedCriteria(Logger logger) {
        if (!this.patterns.isEmpty()) {
            ArrayList<Pattern> missed = new ArrayList<Pattern>(this.patterns);
            missed.removeAll(this.patternsTriggered);
            if (!missed.isEmpty() && logger.isWarnEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("The following patterns were never triggered in this ");
                buffer.append(this.getFilterDescription());
                buffer.append(':');
                for (Pattern pattern : missed) {
                    buffer.append(SEP).append("o  '").append(pattern).append("'");
                }
                buffer.append(SEP);
                logger.warn(buffer.toString());
            }
        }
    }

    public String toString() {
        return "Includes filter:" + this.getPatternsAsString();
    }

    protected String getPatternsAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Pattern pattern : this.patterns) {
            buffer.append(SEP).append("o '").append(pattern).append("'");
        }
        return buffer.toString();
    }

    protected String getFilterDescription() {
        return "artifact inclusion filter";
    }

    @Override
    public void reportFilteredArtifacts(Logger logger) {
        if (!this.filteredArtifact.isEmpty() && logger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder("The following artifacts were removed by this " + this.getFilterDescription() + ": ");
            for (Artifact artifactId : this.filteredArtifact) {
                buffer.append(SEP).append(artifactId.getId());
            }
            logger.debug(buffer.toString());
        }
    }

    @Override
    public boolean hasMissedCriteria() {
        if (!this.patterns.isEmpty()) {
            ArrayList<Pattern> missed = new ArrayList<Pattern>(this.patterns);
            missed.removeAll(this.patternsTriggered);
            return !missed.isEmpty();
        }
        return false;
    }

    private static Artifactoid adapt(Artifact artifact) {
        Objects.requireNonNull(artifact);
        return coordinate -> {
            Objects.requireNonNull(coordinate);
            switch (coordinate) {
                case GROUP_ID: {
                    return artifact.getGroupId();
                }
                case ARTIFACT_ID: {
                    return artifact.getArtifactId();
                }
                case BASE_VERSION: {
                    return artifact.getBaseVersion();
                }
                case CLASSIFIER: {
                    return artifact.hasClassifier() ? artifact.getClassifier() : null;
                }
                case TYPE: {
                    return artifact.getType();
                }
            }
            throw new IllegalArgumentException("unknown coordinate: " + (Object)((Object)coordinate));
        };
    }

    private static Artifactoid adapt(String depTrailString) {
        Objects.requireNonNull(depTrailString);
        String[] coordinates = depTrailString.split(":");
        if (coordinates.length != 4 && coordinates.length != 5) {
            throw new IllegalArgumentException("Bad dep trail string: " + depTrailString);
        }
        HashMap<Coordinate, String> map = new HashMap<Coordinate, String>();
        map.put(Coordinate.GROUP_ID, coordinates[0]);
        map.put(Coordinate.ARTIFACT_ID, coordinates[1]);
        map.put(Coordinate.TYPE, coordinates[2]);
        if (coordinates.length == 5) {
            map.put(Coordinate.CLASSIFIER, coordinates[3]);
            map.put(Coordinate.BASE_VERSION, coordinates[4]);
        } else {
            map.put(Coordinate.BASE_VERSION, coordinates[3]);
        }
        return coordinate -> {
            Objects.requireNonNull(coordinate);
            return (String)map.get((Object)coordinate);
        };
    }

    private static String[] splitAndTokenize(String pattern) {
        String[] stokens = pattern.split(":");
        String[] tokens = new String[stokens.length];
        for (int i = 0; i < stokens.length; ++i) {
            String str = stokens[i];
            tokens[i] = str != null && !str.isEmpty() ? str : ANY;
        }
        return tokens;
    }

    private static Pattern compile(String pattern) {
        if (pattern.startsWith("!")) {
            return new NegativePattern(pattern, PatternIncludesArtifactFilter.compile(pattern.substring(1)));
        }
        String[] tokens = PatternIncludesArtifactFilter.splitAndTokenize(pattern);
        if (tokens.length < 1 || tokens.length > 5) {
            throw new IllegalArgumentException("Invalid pattern: " + pattern);
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(5);
        if (tokens.length == 5) {
            patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[0], Coordinate.GROUP_ID));
            patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[1], Coordinate.ARTIFACT_ID));
            patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[2], Coordinate.TYPE));
            patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[3], Coordinate.CLASSIFIER));
            patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[4], Coordinate.BASE_VERSION));
        } else if (tokens.length == 4) {
            patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[0], Coordinate.GROUP_ID));
            patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[1], Coordinate.ARTIFACT_ID));
            patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[2], Coordinate.TYPE));
            patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[3], Coordinate.BASE_VERSION, Coordinate.CLASSIFIER));
        } else if (tokens.length == 3) {
            if (ANY.equals(tokens[0]) && ANY.equals(tokens[1]) && ANY.equals(tokens[2])) {
                patterns.add(MATCH_ALL_PATTERN);
            } else if (ANY.equals(tokens[0]) && ANY.equals(tokens[1])) {
                patterns.add(PatternIncludesArtifactFilter.toPattern(pattern, tokens[2], Coordinate.TYPE, Coordinate.CLASSIFIER));
            } else if (ANY.equals(tokens[0]) && ANY.equals(tokens[2])) {
                patterns.add(PatternIncludesArtifactFilter.toPattern(pattern, tokens[1], Coordinate.ARTIFACT_ID, Coordinate.TYPE));
            } else if (ANY.equals(tokens[0])) {
                patterns.add(PatternIncludesArtifactFilter.toPattern(pattern, tokens[1], Coordinate.GROUP_ID, Coordinate.ARTIFACT_ID));
                patterns.add(PatternIncludesArtifactFilter.toPattern(pattern, tokens[2], Coordinate.TYPE, Coordinate.CLASSIFIER));
            } else if (ANY.equals(tokens[1]) && ANY.equals(tokens[2])) {
                patterns.add(PatternIncludesArtifactFilter.toPattern(pattern, tokens[0], Coordinate.GROUP_ID, Coordinate.ARTIFACT_ID));
            } else if (ANY.equals(tokens[1])) {
                patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[0], tokens[0], Coordinate.GROUP_ID));
                patterns.add(PatternIncludesArtifactFilter.toPattern(pattern, tokens[2], Coordinate.TYPE, Coordinate.CLASSIFIER));
            } else if (ANY.equals(tokens[2])) {
                patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[0], Coordinate.GROUP_ID));
                patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[1], Coordinate.ARTIFACT_ID));
            } else {
                patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[0], Coordinate.GROUP_ID));
                patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[1], Coordinate.ARTIFACT_ID));
                patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[2], Coordinate.TYPE));
            }
        } else if (tokens.length == 2) {
            if (ANY.equals(tokens[0]) && ANY.equals(tokens[1])) {
                patterns.add(MATCH_ALL_PATTERN);
            } else if (ANY.equals(tokens[0])) {
                patterns.add(PatternIncludesArtifactFilter.toPattern(pattern, tokens[1], Coordinate.GROUP_ID, Coordinate.ARTIFACT_ID, Coordinate.TYPE, Coordinate.BASE_VERSION));
            } else if (ANY.equals(tokens[1])) {
                patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[0], Coordinate.GROUP_ID));
            } else {
                patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[0], Coordinate.GROUP_ID));
                patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[1], Coordinate.ARTIFACT_ID));
            }
        } else {
            patterns.add(PatternIncludesArtifactFilter.toPattern(tokens[0], Coordinate.GROUP_ID));
        }
        if (patterns.size() == 1) {
            Pattern pat = (Pattern)patterns.get(0);
            if (pat == MATCH_ALL_PATTERN) {
                return new MatchAllPattern(pattern);
            }
            return pat;
        }
        return new AndPattern(pattern, patterns.toArray(new Pattern[0]));
    }

    private static Pattern toPattern(String token, Coordinate ... coordinates) {
        return PatternIncludesArtifactFilter.toPattern(token, token, coordinates);
    }

    private static Pattern toPattern(String pattern, String token, Coordinate ... coordinates) {
        if (ANY.equals(token)) {
            return MATCH_ALL_PATTERN;
        }
        EnumSet<Coordinate> coordinateSet = EnumSet.noneOf(Coordinate.class);
        coordinateSet.addAll(Arrays.asList(coordinates));
        return new CoordinateMatchingPattern(pattern, token, coordinateSet);
    }

    private static boolean match(String pattern, boolean containsAsterisk, String value) {
        char ch;
        int strIdxStart;
        char[] patArr = pattern.toCharArray();
        char[] strArr = value != null ? value.toCharArray() : new char[]{};
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxEnd = strArr.length - 1;
        if (!containsAsterisk) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || ch2 == strArr[i]) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        for (strIdxStart = 0; (ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd; ++strIdxStart) {
            if (ch != '?' && ch != strArr[strIdxStart]) {
                return false;
            }
            ++patIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxEnd]) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (patArr[i] != '*') continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block7: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && ch != strArr[strIdxStart + i + j]) continue block7;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    private static class NegativePattern
    extends Pattern {
        private final Pattern inner;

        private NegativePattern(String pattern, Pattern inner) {
            super(pattern);
            this.inner = inner;
        }

        @Override
        public boolean matches(Artifactoid artifactoid) {
            return this.inner.matches(artifactoid);
        }
    }

    private static class MatchAllPattern
    extends Pattern {
        private MatchAllPattern(String pattern) {
            super(pattern);
        }

        @Override
        public boolean matches(Artifactoid artifactoid) {
            return true;
        }
    }

    private static class CoordinateMatchingPattern
    extends Pattern {
        private final String token;
        private final EnumSet<Coordinate> coordinates;
        private final boolean containsWildcard;
        private final boolean containsAsterisk;
        private final VersionRange optionalVersionRange;

        private CoordinateMatchingPattern(String pattern, String token, EnumSet<Coordinate> coordinates) {
            super(pattern);
            this.token = token;
            this.coordinates = coordinates;
            this.containsAsterisk = token.contains(PatternIncludesArtifactFilter.ANY);
            boolean bl = this.containsWildcard = this.containsAsterisk || token.contains("?");
            if (!this.containsWildcard && coordinates.equals(EnumSet.of(Coordinate.BASE_VERSION)) && (token.startsWith("[") || token.startsWith("("))) {
                try {
                    this.optionalVersionRange = VersionRange.createFromVersionSpec((String)token);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new IllegalArgumentException("Wrong version spec: " + token, e);
                }
            } else {
                this.optionalVersionRange = null;
            }
        }

        @Override
        public boolean matches(Artifactoid artifactoid) {
            for (Coordinate coordinate : this.coordinates) {
                String value = artifactoid.getCoordinate(coordinate);
                if (!(Coordinate.BASE_VERSION == coordinate && this.optionalVersionRange != null ? this.optionalVersionRange.containsVersion((ArtifactVersion)new DefaultArtifactVersion(value)) : (this.containsWildcard ? PatternIncludesArtifactFilter.match(this.token, this.containsAsterisk, value) : this.token.equals(value)))) continue;
                return true;
            }
            return false;
        }
    }

    private static class AndPattern
    extends Pattern {
        private final Pattern[] patterns;

        private AndPattern(String pattern, Pattern[] patterns) {
            super(pattern);
            this.patterns = patterns;
        }

        @Override
        public boolean matches(Artifactoid artifactoid) {
            for (Pattern pattern : this.patterns) {
                if (pattern.matches(artifactoid)) continue;
                return false;
            }
            return true;
        }
    }

    private static abstract class Pattern {
        protected final String pattern;

        private Pattern(String pattern) {
            this.pattern = Objects.requireNonNull(pattern);
        }

        public abstract boolean matches(Artifactoid var1);

        public String toString() {
            return this.pattern;
        }
    }

    private static interface Artifactoid {
        public String getCoordinate(Coordinate var1);
    }

    private static enum Coordinate {
        GROUP_ID,
        ARTIFACT_ID,
        TYPE,
        CLASSIFIER,
        BASE_VERSION;

    }
}

