/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.deploy.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.GroupRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployStrategy;

public abstract class AbstractDeployStrategy
implements DeployStrategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private ArtifactInstaller artifactInstaller;
    @Requirement
    private ArtifactDeployer artifactDeployer;
    @Requirement
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Requirement
    private ArtifactRepositoryLayout artifactRepositoryLayout;
    private static final Object parallelLock = new Object();
    private final Pattern indexProps = Pattern.compile("([^:]*):([^:]*):([^:]*):([^:]*):([^:]*):([^:]*):([^:]*):([^:]*):([^:]*):(.*)");

    protected ArtifactRepository createDeploymentArtifactRepository(String id, String url) {
        return this.artifactRepositoryFactory.createDeploymentArtifactRepository(id, url, this.artifactRepositoryLayout, true);
    }

    protected File getStagingDirectory(File stagingDirectoryRoot, String profileId) throws MojoExecutionException {
        File root = stagingDirectoryRoot;
        if (Strings.isNullOrEmpty((String)profileId)) {
            throw new MojoExecutionException("Internal bug: passed in profileId must be non-null and non-empty string!");
        }
        return new File(root, profileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install(File source, Artifact artifact, ArtifactRepository stagingRepository, File stagingDirectory, ArtifactRepository remoteRepository) throws ArtifactInstallationException, MojoExecutionException {
        Object object = parallelLock;
        synchronized (object) {
            String path = stagingRepository.pathOf(artifact);
            try {
                this.artifactInstaller.install(source, artifact, stagingRepository);
                String pluginPrefix = null;
                for (ArtifactMetadata artifactMetadata : artifact.getMetadataList()) {
                    if (!(artifactMetadata instanceof GroupRepositoryMetadata)) continue;
                    Plugin plugin = (Plugin)((GroupRepositoryMetadata)artifactMetadata).getMetadata().getPlugins().get(0);
                    pluginPrefix = plugin.getPrefix();
                }
                FileOutputStream fos = new FileOutputStream(new File(stagingDirectory, ".index"), true);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "ISO-8859-1");
                PrintWriter pw = new PrintWriter(osw);
                String pomFileName = null;
                for (ArtifactMetadata artifactMetadata : artifact.getMetadataList()) {
                    if (!(artifactMetadata instanceof ProjectArtifactMetadata)) continue;
                    pomFileName = artifactMetadata.getLocalFilename(stagingRepository);
                }
                pw.println(String.format("%s=%s:%s:%s:%s:%s:%s:%s:%s:%s:%s", path, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), Strings.isNullOrEmpty((String)artifact.getClassifier()) ? "n/a" : artifact.getClassifier(), artifact.getType(), artifact.getArtifactHandler().getExtension(), Strings.isNullOrEmpty((String)pomFileName) ? "n/a" : pomFileName, Strings.isNullOrEmpty((String)pluginPrefix) ? "n/a" : pluginPrefix, remoteRepository != null ? remoteRepository.getId() : "n/a", remoteRepository != null ? remoteRepository.getUrl() : "n/a"));
                pw.flush();
                pw.close();
            }
            catch (IOException e) {
                throw new ArtifactInstallationException("Cannot locally stage and maintain the index file!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployUp(MavenSession mavenSession, File sourceDirectory, ArtifactRepository remoteRepository) throws ArtifactDeploymentException, IOException {
        FileInputStream fis = new FileInputStream(new File(sourceDirectory, ".index"));
        Properties index = new Properties();
        try {
            index.load(fis);
        }
        finally {
            Closeables.closeQuietly((Closeable)fis);
        }
        ArtifactRepository repoToUse = remoteRepository;
        for (String includedFilePath : index.stringPropertyNames()) {
            String repoUrl;
            File includedFile = new File(sourceDirectory, includedFilePath);
            String includedFileProps = index.getProperty(includedFilePath);
            Matcher matcher = this.indexProps.matcher(includedFileProps);
            if (!matcher.matches()) {
                throw new ArtifactDeploymentException("Internal error! Line \"" + includedFileProps + "\" does not match pattern \"" + this.indexProps.toString() + "\"?");
            }
            String groupId = matcher.group(1);
            String artifactId = matcher.group(2);
            String version = matcher.group(3);
            String classifier = "n/a".equals(matcher.group(4)) ? null : matcher.group(4);
            String packaging = matcher.group(5);
            String extension = matcher.group(6);
            String pomFileName = "n/a".equals(matcher.group(7)) ? null : matcher.group(7);
            String pluginPrefix = "n/a".equals(matcher.group(8)) ? null : matcher.group(8);
            String repoId = "n/a".equals(matcher.group(9)) ? null : matcher.group(9);
            String string = repoUrl = "n/a".equals(matcher.group(10)) ? null : matcher.group(10);
            if (remoteRepository == null) {
                if (repoUrl != null && repoId != null) {
                    repoToUse = this.createDeploymentArtifactRepository(repoId, repoUrl);
                } else {
                    throw new ArtifactDeploymentException("Internal error! Remote repository for deployment not defined.");
                }
            }
            FakeArtifactHandler artifactHandler = new FakeArtifactHandler(packaging, extension);
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), null, packaging, classifier, (ArtifactHandler)artifactHandler);
            if (pomFileName != null) {
                File pomFile = new File(includedFile.getParentFile(), pomFileName);
                ProjectArtifactMetadata pom = new ProjectArtifactMetadata((Artifact)artifact, pomFile);
                artifact.addMetadata((ArtifactMetadata)pom);
                if ("maven-plugin".equals(artifact.getType())) {
                    GroupRepositoryMetadata groupMetadata = new GroupRepositoryMetadata(groupId);
                    groupMetadata.addPluginMapping(pluginPrefix, artifactId, artifactId);
                    artifact.addMetadata((ArtifactMetadata)groupMetadata);
                }
            }
            this.artifactDeployer.deploy(includedFile, (Artifact)artifact, repoToUse, mavenSession.getLocalRepository());
        }
    }

    protected ArtifactRepository getDeploymentRepository(MavenSession mavenSession) throws MojoExecutionException {
        ArtifactRepository repo = mavenSession.getCurrentProject().getDistributionManagementArtifactRepository();
        if (repo == null) {
            String msg = "Deployment failed: repository element was not specified in the POM inside distributionManagement element or in -DaltDeploymentRepository=id::layout::url parameter";
            throw new MojoExecutionException(msg);
        }
        return repo;
    }

    protected ArtifactRepository getArtifactRepositoryForDirectory(File stagingDirectory) throws MojoExecutionException {
        if (stagingDirectory != null) {
            if (!(!stagingDirectory.exists() || stagingDirectory.canWrite() && stagingDirectory.isDirectory())) {
                throw new MojoExecutionException("Staging failed: staging directory points to an existing file but is not a directory or is not writable!");
            }
            if (!stagingDirectory.exists()) {
                stagingDirectory.mkdirs();
            }
            try {
                String id = "nexus";
                String url = stagingDirectory.getCanonicalFile().toURI().toURL().toExternalForm();
                return this.createDeploymentArtifactRepository("nexus", url);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Staging failed: staging directory path cannot be converted to canonical one!", (Exception)e);
            }
        }
        throw new MojoExecutionException("Staging failed: staging directory is null!");
    }

    public static class FakeArtifactHandler
    extends DefaultArtifactHandler {
        private final String extension;

        public FakeArtifactHandler(String type, String extension) {
            super((String)Preconditions.checkNotNull((Object)type));
            this.extension = (String)Preconditions.checkNotNull((Object)extension);
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

