/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.classrealm;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.classrealm.ArtifactClassRealmConstituent;
import org.apache.maven.classrealm.ClassRealmConstituent;
import org.apache.maven.classrealm.ClassRealmManager;
import org.apache.maven.classrealm.ClassRealmManagerDelegate;
import org.apache.maven.classrealm.ClassRealmRequest;
import org.apache.maven.classrealm.DefaultClassRealmRequest;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ClassRealmManager.class)
public class DefaultClassRealmManager
implements ClassRealmManager {
    @Requirement
    private Logger logger;
    @Requirement
    protected PlexusContainer container;
    private ClassRealm mavenRealm;

    private ClassWorld getClassWorld() {
        return ((MutablePlexusContainer)this.container).getClassWorld();
    }

    private ClassRealm newRealm(String id) {
        ClassWorld world;
        ClassWorld classWorld = world = this.getClassWorld();
        synchronized (classWorld) {
            String realmId = id;
            Random random = new Random();
            while (true) {
                try {
                    ClassRealm classRealm = world.newRealm(realmId, null);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Created new class realm " + realmId);
                    }
                    return classRealm;
                }
                catch (DuplicateRealmException e) {
                    realmId = id + '-' + random.nextInt();
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public synchronized ClassRealm getMavenApiRealm() {
        if (this.mavenRealm == null) {
            this.mavenRealm = this.newRealm("maven.api");
            ArrayList<ClassRealmConstituent> constituents = new ArrayList<ClassRealmConstituent>();
            ArrayList<String> parentImports = new ArrayList<String>();
            HashMap<String, ClassLoader> foreignImports = new HashMap<String, ClassLoader>();
            this.importMavenApi(foreignImports);
            this.callDelegates(this.mavenRealm, ClassRealmRequest.RealmType.Core, this.mavenRealm.getParentClassLoader(), parentImports, foreignImports, constituents);
            this.wireRealm(this.mavenRealm, parentImports, foreignImports);
            this.populateRealm(this.mavenRealm, constituents);
        }
        return this.mavenRealm;
    }

    private void importMavenApi(Map<String, ClassLoader> imports) {
        ClassRealm coreRealm = this.getCoreRealm();
        imports.put("org.apache.maven.*", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.artifact", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.classrealm", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.cli", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.configuration", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.exception", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.execution", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.lifecycle", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.model", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.monitor", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.plugin", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.profiles", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.project", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.reporting", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.repository", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.rtinfo", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.settings", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.toolchain", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.usability", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.wagon.*", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.wagon.authentication", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.wagon.authorization", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.wagon.events", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.wagon.observers", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.wagon.proxy", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.wagon.repository", (ClassLoader)coreRealm);
        imports.put("org.apache.maven.wagon.resource", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.*", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.artifact", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.collection", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.deployment", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.graph", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.impl", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.internal.impl", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.installation", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.metadata", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.repository", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.resolution", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.spi", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.transfer", (ClassLoader)coreRealm);
        imports.put("org.eclipse.aether.version", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.classworlds", (ClassLoader)coreRealm);
        imports.put("org.codehaus.classworlds", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.util.xml.Xpp3Dom", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.util.xml.pull.XmlPullParser", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.util.xml.pull.XmlPullParserException", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.util.xml.pull.XmlSerializer", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.*", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.component", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.configuration", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.container", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.context", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.lifecycle", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.logging", (ClassLoader)coreRealm);
        imports.put("org.codehaus.plexus.personality", (ClassLoader)coreRealm);
        imports.put("javax.inject.*", (ClassLoader)coreRealm);
        imports.put("javax.enterprise.inject.*", (ClassLoader)coreRealm);
        imports.put("org.slf4j.*", (ClassLoader)coreRealm);
    }

    private ClassRealm createRealm(String baseRealmId, ClassRealmRequest.RealmType type, ClassLoader parent, List<String> parentImports, Map<String, ClassLoader> foreignImports, List<Artifact> artifacts) {
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        ArrayList<ClassRealmConstituent> constituents = new ArrayList<ClassRealmConstituent>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                artifactIds.add(DefaultClassRealmManager.getId(artifact));
                if (artifact.getFile() == null) continue;
                constituents.add(new ArtifactClassRealmConstituent(artifact));
            }
        }
        parentImports = parentImports != null ? new ArrayList<String>(parentImports) : new ArrayList<String>();
        foreignImports = foreignImports != null ? new TreeMap<String, ClassLoader>(foreignImports) : new TreeMap<String, ClassLoader>();
        ClassRealm classRealm = this.newRealm(baseRealmId);
        if (parent != null) {
            classRealm.setParentClassLoader(parent);
        }
        this.callDelegates(classRealm, type, parent, parentImports, foreignImports, constituents);
        this.wireRealm(classRealm, parentImports, foreignImports);
        Set<String> includedIds = this.populateRealm(classRealm, constituents);
        if (this.logger.isDebugEnabled()) {
            artifactIds.removeAll(includedIds);
            for (String id : artifactIds) {
                this.logger.debug("  Excluded: " + id);
            }
        }
        return classRealm;
    }

    @Override
    public ClassRealm getCoreRealm() {
        return this.container.getContainerRealm();
    }

    @Override
    public ClassRealm createProjectRealm(Model model, List<Artifact> artifacts) {
        if (model == null) {
            throw new IllegalArgumentException("model missing");
        }
        ClassRealm parent = this.getMavenApiRealm();
        return this.createRealm(DefaultClassRealmManager.getKey(model), ClassRealmRequest.RealmType.Project, (ClassLoader)parent, null, null, artifacts);
    }

    private static String getKey(Model model) {
        return "project>" + model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion();
    }

    @Override
    public ClassRealm createExtensionRealm(Plugin plugin, List<Artifact> artifacts) {
        if (plugin == null) {
            throw new IllegalArgumentException("extension plugin missing");
        }
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        Map<String, ClassRealm> foreignImports = Collections.singletonMap("", this.getMavenApiRealm());
        return this.createRealm(DefaultClassRealmManager.getKey(plugin, true), ClassRealmRequest.RealmType.Extension, parent, null, foreignImports, artifacts);
    }

    @Override
    public ClassRealm createPluginRealm(Plugin plugin, ClassLoader parent, List<String> parentImports, Map<String, ClassLoader> foreignImports, List<Artifact> artifacts) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin missing");
        }
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return this.createRealm(DefaultClassRealmManager.getKey(plugin, false), ClassRealmRequest.RealmType.Plugin, parent, parentImports, foreignImports, artifacts);
    }

    private static String getKey(Plugin plugin, boolean extension) {
        String version = ArtifactUtils.toSnapshotVersion((String)plugin.getVersion());
        return (extension ? "extension>" : "plugin>") + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + version;
    }

    private static String getId(Artifact artifact) {
        return DefaultClassRealmManager.getId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getBaseVersion());
    }

    private static String getId(ClassRealmConstituent constituent) {
        return DefaultClassRealmManager.getId(constituent.getGroupId(), constituent.getArtifactId(), constituent.getType(), constituent.getClassifier(), constituent.getVersion());
    }

    private static String getId(String gid, String aid, String type, String cls, String ver) {
        return gid + ':' + aid + ':' + type + (StringUtils.isNotEmpty((String)cls) ? ':' + cls : "") + ':' + ver;
    }

    private List<ClassRealmManagerDelegate> getDelegates() {
        try {
            return this.container.lookupList(ClassRealmManagerDelegate.class);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup class realm delegates: " + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private void callDelegates(ClassRealm classRealm, ClassRealmRequest.RealmType type, ClassLoader parent, List<String> parentImports, Map<String, ClassLoader> foreignImports, List<ClassRealmConstituent> constituents) {
        List<ClassRealmManagerDelegate> delegates = this.getDelegates();
        if (!delegates.isEmpty()) {
            DefaultClassRealmRequest request = new DefaultClassRealmRequest(type, parent, parentImports, foreignImports, constituents);
            for (ClassRealmManagerDelegate delegate : delegates) {
                try {
                    delegate.setupRealm(classRealm, request);
                }
                catch (Exception e) {
                    this.logger.error(delegate.getClass().getName() + " failed to setup class realm " + classRealm + ": " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Set<String> populateRealm(ClassRealm classRealm, List<ClassRealmConstituent> constituents) {
        LinkedHashSet<String> includedIds = new LinkedHashSet<String>();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Populating class realm " + classRealm.getId());
        }
        for (ClassRealmConstituent constituent : constituents) {
            File file = constituent.getFile();
            String id = DefaultClassRealmManager.getId(constituent);
            includedIds.add(id);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("  Included: " + id);
            }
            try {
                classRealm.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return includedIds;
    }

    private void wireRealm(ClassRealm classRealm, List<String> parentImports, Map<String, ClassLoader> foreignImports) {
        if (foreignImports != null && !foreignImports.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Importing foreign packages into class realm " + classRealm.getId());
            }
            for (Map.Entry entry : foreignImports.entrySet()) {
                ClassLoader importedRealm = (ClassLoader)entry.getValue();
                String imp = (String)entry.getKey();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("  Imported: " + imp + " < " + this.getId(importedRealm));
                }
                classRealm.importFrom(importedRealm, imp);
            }
        }
        if (parentImports != null && !parentImports.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Importing parent packages into class realm " + classRealm.getId());
            }
            for (String string : parentImports) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("  Imported: " + string + " < " + this.getId(classRealm.getParentClassLoader()));
                }
                classRealm.importFromParent(string);
            }
        }
    }

    private String getId(ClassLoader classLoader) {
        if (classLoader instanceof ClassRealm) {
            return ((ClassRealm)classLoader).getId();
        }
        return String.valueOf(classLoader);
    }
}

