/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.client.internal;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.sonatype.nexus.staging.api.dto.StagingRuleSetDTO;
import com.sonatype.nexus.staging.api.dto.StagingRuleSetListResponseDTO;
import com.sonatype.nexus.staging.api.dto.StagingRuleSetResponseDTO;
import com.sonatype.nexus.staging.api.dto.StagingXStreamConfigurator;
import com.sonatype.nexus.staging.client.StagingRuleSet;
import com.sonatype.nexus.staging.client.StagingRuleSets;
import com.sonatype.nexus.staging.client.internal.JerseyStagingRuleSet;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.client.core.NexusClient;
import org.sonatype.nexus.client.core.spi.SubsystemSupport;
import org.sonatype.nexus.client.rest.jersey.ContextAwareUniformInterfaceException;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;

public class JerseyStagingRuleSets
extends SubsystemSupport<JerseyNexusClient>
implements StagingRuleSets {
    public JerseyStagingRuleSets(JerseyNexusClient nexusClient) {
        super((NexusClient)nexusClient);
        StagingXStreamConfigurator.configureXStream(nexusClient.getXStream());
    }

    public StagingRuleSet create(String id) {
        if (id != null) {
            throw new IllegalArgumentException("Staging set id is automatically generated. Use 'null' or the other create method");
        }
        return this.create();
    }

    @Override
    public StagingRuleSet create() {
        return new JerseyStagingRuleSet((JerseyNexusClient)this.getNexusClient());
    }

    public StagingRuleSet get(String id) {
        try {
            return this.convert(((StagingRuleSetResponseDTO)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyStagingRuleSets.path(id)).get(StagingRuleSetResponseDTO.class)).getData());
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert((UniformInterfaceException)((Object)new StagingRuleSetNotFoundException(e.getResponse(), id)));
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    public Collection<StagingRuleSet> get() {
        StagingRuleSetListResponseDTO ruleSets;
        try {
            ruleSets = (StagingRuleSetListResponseDTO)((JerseyNexusClient)this.getNexusClient()).serviceResource("staging/rule_sets").get(StagingRuleSetListResponseDTO.class);
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        return Collections2.transform(ruleSets.getData(), (Function)new Function<StagingRuleSetDTO, StagingRuleSet>(){

            public StagingRuleSet apply(@Nullable StagingRuleSetDTO input) {
                return JerseyStagingRuleSets.this.convert(input);
            }
        });
    }

    private JerseyStagingRuleSet convert(@Nullable StagingRuleSetDTO resource) {
        if (resource == null) {
            return null;
        }
        JerseyStagingRuleSet stagingProfile = new JerseyStagingRuleSet((JerseyNexusClient)this.getNexusClient(), resource);
        stagingProfile.overwriteWith(resource);
        return stagingProfile;
    }

    public static String path(String id) {
        try {
            return "staging/rule_sets/" + URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static class StagingRuleSetNotFoundException
    extends ContextAwareUniformInterfaceException {
        private String id;

        StagingRuleSetNotFoundException(ClientResponse response, String id) {
            super(response);
            this.id = id;
        }

        public String getMessage(int status) {
            if (status == Response.Status.NOT_FOUND.getStatusCode()) {
                return String.format("Staging rule set with id '%s' was not found", this.id);
            }
            return null;
        }
    }
}

