/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.sink.render.RenderingContext;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.tools.MojoLogWrapper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;

public class ReportDocumentRenderer
implements DocumentRenderer {
    private final MavenReport report;
    private final RenderingContext renderingContext;
    private final String pluginInfo;
    private final ClassLoader classLoader;
    private final Log log;

    public ReportDocumentRenderer(MavenReportExecution mavenReportExecution, RenderingContext renderingContext, Log log) {
        this.report = mavenReportExecution.getMavenReport();
        this.renderingContext = renderingContext;
        this.pluginInfo = mavenReportExecution.getPlugin() == null ? this.getPluginInfo(this.report) : mavenReportExecution.getPlugin().getArtifactId() + ':' + mavenReportExecution.getPlugin().getVersion();
        this.classLoader = mavenReportExecution.getClassLoader();
        this.log = log;
    }

    private String getPluginInfo(MavenReport report) {
        Package pkg = report.getClass().getPackage();
        if (pkg != null) {
            String title = pkg.getSpecificationTitle();
            String version = pkg.getSpecificationVersion();
            if (title == null) {
                return version;
            }
            if (version == null) {
                return title;
            }
            return title + ' ' + version;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderDocument(Writer writer, Renderer renderer, SiteRenderingContext siteRenderingContext) throws RendererException, FileNotFoundException {
        Locale locale = siteRenderingContext.getLocale();
        String localReportName = this.report.getName(locale);
        this.log.info((CharSequence)("Generating \"" + localReportName + "\" report" + (this.pluginInfo == null ? "." : "    --- " + this.pluginInfo)));
        MySinkFactory sf = new MySinkFactory(this.renderingContext);
        SiteRendererSink sink = new SiteRendererSink(this.renderingContext);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.classLoader != null) {
            Thread.currentThread().setContextClassLoader(this.classLoader);
        }
        try {
            if (this.report instanceof MavenMultiPageReport) {
                ((MavenMultiPageReport)this.report).generate((Sink)sink, sf, locale);
            } else if (this.generateMultiPage(locale, sf, (Sink)sink)) {
            } else {
                this.report.generate((org.codehaus.doxia.sink.Sink)sink, locale);
            }
        }
        catch (MavenReportException e) {
            throw new RendererException("Error rendering Maven report: " + e.getMessage(), (Throwable)e);
        }
        catch (LinkageError e) {
            this.log.warn((CharSequence)("An issue has occurred with report " + this.report.getClass().getName() + ", skip LinkageError " + e.getMessage() + ", please report an issue to Maven dev team."), (Throwable)e);
        }
        finally {
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            sink.close();
        }
        if (!this.report.isExternalReport()) {
            try {
                List<MySink> sinks = sf.sinks();
                this.log.debug((CharSequence)("Multipage report: " + sinks.size() + " subreports"));
                for (MySink mySink : sinks) {
                    mySink.enableLogging((org.apache.maven.doxia.logging.Log)new MojoLogWrapper(this.log));
                    this.log.debug((CharSequence)("  Rendering " + mySink.getOutputName()));
                    File outputFile = new File(mySink.getOutputDir(), mySink.getOutputName());
                    Writer out = null;
                    try {
                        out = WriterFactory.newWriter((File)outputFile, (String)siteRenderingContext.getOutputEncoding());
                        renderer.generateDocument(out, (SiteRendererSink)mySink, siteRenderingContext);
                    }
                    finally {
                        mySink.close();
                        IOUtil.close((Writer)out);
                    }
                }
            }
            catch (IOException e) {
                throw new RendererException("Cannot create writer", (Throwable)e);
            }
            renderer.generateDocument(writer, sink, siteRenderingContext);
        }
    }

    private boolean generateMultiPage(Locale locale, SinkFactory sf, Sink sink) throws MavenReportException {
        try {
            Method generate = this.report.getClass().getMethod("generate", Sink.class, SinkFactory.class, Locale.class);
            generate.invoke((Object)this.report, sink, sf, locale);
            return true;
        }
        catch (SecurityException se) {
            return false;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        catch (IllegalArgumentException iae) {
            throw new MavenReportException("error while invoking generate", (Exception)iae);
        }
        catch (IllegalAccessException iae) {
            throw new MavenReportException("error while invoking generate", (Exception)iae);
        }
        catch (InvocationTargetException ite) {
            throw new MavenReportException("error while invoking generate", (Exception)ite);
        }
    }

    public String getOutputName() {
        return this.renderingContext.getOutputName();
    }

    public RenderingContext getRenderingContext() {
        return this.renderingContext;
    }

    public boolean isOverwrite() {
        return true;
    }

    public boolean isExternalReport() {
        return this.report.isExternalReport();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MySinkFactory
    implements SinkFactory {
        private RenderingContext context;
        private List<MySink> sinks = new ArrayList<MySink>();

        public MySinkFactory(RenderingContext ctx) {
            this.context = ctx;
        }

        public Sink createSink(File outputDir, String outputName) {
            MySink sink = new MySink(outputDir, outputName, this.context);
            this.sinks.add(sink);
            return sink;
        }

        public Sink createSink(File arg0, String arg1, String arg2) throws IOException {
            return null;
        }

        public Sink createSink(OutputStream arg0) throws IOException {
            return null;
        }

        public Sink createSink(OutputStream arg0, String arg1) throws IOException {
            return null;
        }

        public List<MySink> sinks() {
            return this.sinks;
        }
    }

    private static class MySink
    extends SiteRendererSink {
        private File outputDir;
        private String outputName;

        public MySink(File outputDir, String outputName, RenderingContext ctx) {
            super(ctx);
            this.outputName = outputName;
            this.outputDir = outputDir;
        }

        public String getOutputName() {
            return this.outputName;
        }

        public File getOutputDir() {
            return this.outputDir;
        }
    }
}

