/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.mpp;

import io.kotest.mpp.Property;
import io.kotest.mpp.reflectionjvm;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u001a\u0012\u0010\t\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0002\u001a\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"nonPrimitiveStableTypes", "", "Lkotlin/reflect/KClass;", "Ljava/io/Serializable;", "primitiveTypes", "", "hasStableMembers", "", "kclass", "isStable", "type", "Lkotlin/reflect/KType;", "kotest-common"})
public final class StableKt {
    @NotNull
    private static final Set<KClass<? extends Object>> primitiveTypes;
    @NotNull
    private static final Set<KClass<? extends Serializable>> nonPrimitiveStableTypes;

    public static final boolean isStable(@NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier classifier = type.getClassifier();
        return classifier instanceof KClass ? StableKt.isStable((KClass)classifier) : false;
    }

    public static final boolean isStable(@NotNull KClass<?> kclass) {
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        return primitiveTypes.contains(kclass) || CollectionsKt.contains((Iterable)nonPrimitiveStableTypes, kclass) ? true : reflectionjvm.getReflection().isEnumClass(kclass) || reflectionjvm.getReflection().isDataClass(kclass) && StableKt.hasStableMembers(kclass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasStableMembers(KClass<?> kclass) {
        Property it;
        List<Property> members = reflectionjvm.getReflection().primaryConstructorMembers(kclass);
        boolean bl = false;
        if (((Collection)members).isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = members;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (Property)element$iv;
            boolean bl3 = false;
        } while (StableKt.isStable(it.getType()));
        return false;
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(String.class), Reflection.getOrCreateKotlinClass(Integer.TYPE), Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(Float.TYPE), Reflection.getOrCreateKotlinClass(Byte.TYPE), Reflection.getOrCreateKotlinClass(Short.TYPE), Reflection.getOrCreateKotlinClass(Boolean.TYPE)};
        primitiveTypes = SetsKt.setOf((Object[])objectArray);
        objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Pair.class), Reflection.getOrCreateKotlinClass(Triple.class)};
        nonPrimitiveStableTypes = SetsKt.setOf((Object[])objectArray);
    }
}

