/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.indexing.IndexingDataKeys;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance(PsiJavaFileBaseImpl.class);
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;
    private volatile String myPackageName;
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.create("LANGUAGE_LEVEL", file2 -> file2.getLanguageLevelInner());
    private static final Key<String> SHEBANG_SOURCE_LEVEL = Key.create("SHEBANG_SOURCE_LEVEL");

    protected PsiJavaFileBaseImpl(IElementType elementType, IElementType contentElementType, FileViewProvider viewProvider) {
        super(elementType, contentElementType, viewProvider);
        this.myResolveCache = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new MyCacheBuilder(this), false);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myPackageName = null;
    }

    @Override
    public PsiClass @NotNull [] getClasses() {
        StubElement stub2 = this.getGreenStub();
        if (stub2 != null) {
            PsiClass[] psiClassArray = (PsiClass[])stub2.getChildrenByType(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
            if (psiClassArray == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(0);
            }
            return psiClassArray;
        }
        PsiClass[] psiClassArray = (PsiClass[])this.calcTreeElement().getChildrenAsPsiElements(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(1);
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.PACKAGE_STATEMENT);
        return node != null ? (PsiPackageStatement)node.getPsi() : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiJavaFileStub stub2 = (PsiJavaFileStub)this.getGreenStub();
        if (stub2 != null) {
            String string2 = stub2.getPackageName();
            if (string2 == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(2);
            }
            return string2;
        }
        String name = this.myPackageName;
        if (name == null) {
            PsiPackageStatement statement2 = this.getPackageStatement();
            name = statement2 == null ? "" : statement2.getPackageName();
            this.myPackageName = name;
        }
        String string3 = name;
        if (string3 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(3);
        }
        return string3;
    }

    @Override
    public void setPackageName(String packageName) throws IncorrectOperationException {
        if (PsiUtil.isModuleFile(this)) {
            throw new IncorrectOperationException("Cannot set package name for module declarations");
        }
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(this.getProject());
        if (packageStatement != null) {
            if (!packageName.isEmpty()) {
                PsiJavaCodeReferenceElement reference = packageStatement.getPackageReference();
                reference.replace(factory2.createReferenceFromText(packageName, packageStatement));
            } else {
                packageStatement.delete();
            }
        } else if (!packageName.isEmpty()) {
            this.cleanupBrokenPackageKeyword();
            PsiElement anchor2 = this.getFirstChild();
            if ("package-info.java".equals(this.getName())) {
                String text2;
                anchor2 = this.getImportList();
                assert (anchor2 != null);
                PsiElement prev = anchor2.getPrevSibling();
                if (prev instanceof PsiComment && (text2 = prev.getText().trim()).startsWith("/*") && !text2.endsWith("*/")) {
                    prev.replace(factory2.createCommentFromText(text2 + (StringUtil.containsLineBreak(text2) ? "\n*/" : " */"), prev));
                }
            }
            this.addBefore(factory2.createPackageStatement(packageName), anchor2);
        }
    }

    private void cleanupBrokenPackageKeyword() {
        PsiElement child = this.getFirstChild();
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof PsiErrorElement) {
            if (child instanceof PsiErrorElement && child.getFirstChild() != null && child.getFirstChild().textMatches("package")) {
                child.delete();
                break;
            }
            child = child.getNextSibling();
        }
    }

    @Override
    public PsiImportList getImportList() {
        StubElement stub2 = this.getGreenStub();
        if (stub2 != null) {
            PsiImportList[] nodes = (PsiImportList[])stub2.getChildrenByType(JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY);
            if (nodes.length == 1) {
                return nodes[0];
            }
            assert (nodes.length == 0);
            return null;
        }
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.IMPORT_LIST);
        return (PsiImportList)SourceTreeToPsiMap.treeElementToPsi(node);
    }

    @Override
    public PsiElement @NotNull [] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements2;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (EMPTY_ARRAY == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(4);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array2 = new ArrayList<PsiElement>();
        for (PsiImportStatement statement2 : statements2 = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement2.isOnDemand() || (resolved = statement2.resolve()) == null) continue;
            array2.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array2.add(resolved);
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array2);
        if (psiElementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    @Override
    public PsiClass @NotNull [] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements2;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(6);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> array2 = new ArrayList<PsiClass>();
        for (PsiImportStatement statement2 : statements2 = importList.getImportStatements()) {
            PsiElement ref;
            if (statement2.isOnDemand() || !((ref = statement2.resolve()) instanceof PsiClass)) continue;
            array2.add((PsiClass)ref);
        }
        PsiClass[] psiClassArray = array2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(7);
        }
        return psiClassArray;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        PsiImportList importList = this.getImportList();
        if (importList != null) {
            PsiImportStatement[] statements2;
            for (PsiImportStatement statement2 : statements2 = importList.getImportStatements()) {
                PsiElement ref;
                if (statement2.isOnDemand() || (ref = statement2.resolve()) == null || !this.getManager().areElementsEquivalent(ref, aClass)) continue;
                return statement2.getImportReference();
            }
        }
        return null;
    }

    @Override
    public String @NotNull [] getImplicitlyImportedPackages() {
        if (IMPLICIT_IMPORTS == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(8);
        }
        return IMPLICIT_IMPORTS;
    }

    @Override
    public PsiJavaCodeReferenceElement @NotNull [] getImplicitlyImportedPackageReferences() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = PsiImplUtil.namesToPackageReferences(this.myManager, IMPLICIT_IMPORTS);
        if (psiJavaCodeReferenceElementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(9);
        }
        return psiJavaCodeReferenceElementArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        Iterable<SymbolCollectingProcessor.ResultWithContext> iterable;
        NameHint nameHint;
        if (processor2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(10);
        }
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(11);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(12);
        }
        String name = (nameHint = processor2.getHint(NameHint.KEY)) != null ? nameHint.getName(state) : null;
        Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> explicitlyEnumerated = this.getExplicitlyEnumeratedDeclarations();
        Iterable<SymbolCollectingProcessor.ResultWithContext> iterable2 = iterable = name != null ? explicitlyEnumerated.get(name) : ContainerUtil.concat(explicitlyEnumerated.values().toArray(new Iterable[0]));
        if (iterable != null && !ContainerUtil.process(iterable, new MyResolveCacheProcessor(processor2, state))) {
            return false;
        }
        if (processor2 instanceof ClassResolverProcessor && (this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue()) && !PsiUtil.isInsideJavadocComment(place)) {
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> cache2 = this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(processor2, state);
            return name != null ? cache2.processForKey(name, cacheProcessor) : cache2.processAllValues(cacheProcessor);
        }
        return this.processOnDemandPackages(processor2, state, place);
    }

    private Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> getExplicitlyEnumeratedDeclarations() {
        return (Map)CachedValuesManager.getCachedValue(this, () -> {
            String name;
            MultiMap<String, PsiClass> ownClasses = MultiMap.create();
            MultiMap<String, PsiElement> typeImports = MultiMap.create();
            MultiMap<String, PsiElement> staticImports = MultiMap.create();
            for (PsiClass psiClass : this.getClasses()) {
                name = psiClass.getName();
                if (name == null) continue;
                ownClasses.putValue(name, psiClass);
            }
            for (PsiElement psiElement : this.getImportStatements()) {
                String qName;
                if (psiElement.isOnDemand() || (qName = psiElement.getQualifiedName()) == null) continue;
                typeImports.putValue(StringUtil.getShortName(qName), psiElement);
            }
            for (PsiElement psiElement : this.getImportStaticStatements()) {
                name = psiElement.getReferenceName();
                if (name == null) continue;
                staticImports.putValue(name, psiElement);
            }
            LinkedHashMap result2 = new LinkedHashMap();
            for (String name2 : ContainerUtil.newLinkedHashSet(ContainerUtil.concat(ownClasses.keySet(), typeImports.keySet(), staticImports.keySet()))) {
                VolatileNotNullLazyValue<Iterable> volatileNotNullLazyValue = VolatileNotNullLazyValue.createValue(() -> PsiJavaFileBaseImpl.findExplicitDeclarations(name2, ownClasses, typeImports, staticImports));
                result2.put(name2, () -> ((Iterable)lazy.getValue()).iterator());
            }
            return CachedValueProvider.Result.create(result2, PsiModificationTracker.MODIFICATION_COUNT);
        });
    }

    private static Iterable<SymbolCollectingProcessor.ResultWithContext> findExplicitDeclarations(String name, MultiMap<String, PsiClass> ownClasses, MultiMap<String, PsiImportStatement> typeImports, MultiMap<String, PsiImportStaticStatement> staticImports) {
        ArrayList<SymbolCollectingProcessor.ResultWithContext> result2 = new ArrayList<SymbolCollectingProcessor.ResultWithContext>();
        for (PsiClass psiClass : ownClasses.get(name)) {
            result2.add(new SymbolCollectingProcessor.ResultWithContext(psiClass, null));
        }
        for (PsiImportStatement psiImportStatement : typeImports.get(name)) {
            PsiElement target = psiImportStatement.resolve();
            if (!(target instanceof PsiClass)) continue;
            result2.add(new SymbolCollectingProcessor.ResultWithContext((PsiNamedElement)target, psiImportStatement));
        }
        for (PsiImportStaticStatement psiImportStaticStatement : staticImports.get(name)) {
            PsiJavaCodeReferenceElement reference = psiImportStaticStatement.getImportReference();
            if (reference == null) continue;
            for (JavaResolveResult result1 : reference.multiResolve(false)) {
                PsiElement element = result1.getElement();
                if (!(element instanceof PsiNamedElement)) continue;
                result2.add(new SymbolCollectingProcessor.ResultWithContext((PsiNamedElement)element, psiImportStaticStatement));
            }
        }
        return JBIterable.from(result2).unique(SymbolCollectingProcessor.ResultWithContext::getElement);
    }

    private boolean processOnDemandPackages(PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement place) {
        ElementClassHint classHint;
        boolean shouldProcessClasses;
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(13);
        }
        boolean bl = shouldProcessClasses = (classHint = processor2.getHint(ElementClassHint.KEY)) == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS);
        if (shouldProcessClasses) {
            if (!this.processCurrentPackage(processor2, state, place)) {
                return false;
            }
            if (!this.processOnDemandTypeImports(processor2, state, place)) {
                return false;
            }
        }
        if (!this.processOnDemandStaticImports(state, new StaticImportFilteringProcessor(processor2, this.getExplicitlyEnumeratedDeclarations()))) {
            return false;
        }
        return !shouldProcessClasses || this.processImplicitImports(processor2, state, place);
    }

    private PsiImportStaticStatement[] getImportStaticStatements() {
        return this.getImportList() != null ? this.getImportList().getImportStaticStatements() : PsiImportStaticStatement.EMPTY_ARRAY;
    }

    private PsiImportStatement[] getImportStatements() {
        return this.getImportList() != null ? this.getImportList().getImportStatements() : PsiImportStatement.EMPTY_ARRAY;
    }

    private boolean processCurrentPackage(PsiScopeProcessor processor2, ResolveState state, PsiElement place) {
        processor2.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
        PsiPackage aPackage = JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.getPackageName());
        return aPackage == null || PsiJavaFileBaseImpl.processPackageDeclarations(processor2, state, place, aPackage);
    }

    private boolean processOnDemandTypeImports(PsiScopeProcessor processor2, ResolveState state, PsiElement place) {
        for (PsiImportStatement statement2 : this.getImportStatements()) {
            PsiElement resolved;
            if (!statement2.isOnDemand() || (resolved = statement2.resolve()) == null) continue;
            processor2.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, statement2);
            if (PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor2, state, place)) continue;
            return false;
        }
        return true;
    }

    private boolean processOnDemandStaticImports(ResolveState state, StaticImportFilteringProcessor processor2) {
        for (PsiImportStaticStatement importStaticStatement : this.getImportStaticStatements()) {
            PsiClass targetElement;
            if (!importStaticStatement.isOnDemand() || (targetElement = importStaticStatement.resolveTargetClass()) == null) continue;
            processor2.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, importStaticStatement);
            if (PsiClassImplUtil.processAllMembersWithoutSubstitutors(targetElement, processor2, state)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitImports(PsiScopeProcessor processor2, ResolveState state, PsiElement place) {
        processor2.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
        for (PsiJavaCodeReferenceElement aImplicitlyImported : this.getImplicitlyImportedPackageReferences()) {
            PsiElement resolved = aImplicitlyImported.resolve();
            if (resolved == null || PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor2, state, place)) continue;
            return false;
        }
        return true;
    }

    private static boolean processPackageDeclarations(PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement place, @NotNull PsiPackage aPackage) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(14);
        }
        if (aPackage == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(15);
        }
        if (!aPackage.getQualifiedName().isEmpty()) {
            processor2 = new DelegatingScopeProcessor(processor2){

                @Override
                @Nullable
                public <T> T getHint(@NotNull Key<T> hintKey) {
                    if (hintKey == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (hintKey == ElementClassHint.KEY) {
                        return (T)((ElementClassHint)kind -> kind == ElementClassHint.DeclarationKind.CLASS);
                    }
                    return super.getHint(hintKey);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$1", "getHint"));
                }
            };
        }
        return aPackage.processDeclarations(processor2, state, null, place);
    }

    @NotNull
    private static PsiSubstitutor createRawSubstitutor(PsiClass containingClass) {
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(containingClass.getProject()).createRawSubstitutor(containingClass);
        if (psiSubstitutor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(16);
        }
        return psiSubstitutor;
    }

    private static boolean processOnDemandTarget(PsiElement target, PsiScopeProcessor processor2, ResolveState substitutor2, PsiElement place) {
        if (target instanceof PsiPackage) {
            if (!PsiJavaFileBaseImpl.processPackageDeclarations(processor2, substitutor2, place, (PsiPackage)target)) {
                return false;
            }
        } else if (target instanceof PsiClass) {
            PsiClass[] inners = ((PsiClass)target).getInnerClasses();
            if (((PsiClass)target).hasTypeParameters()) {
                substitutor2 = substitutor2.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor((PsiClass)target));
            }
            for (PsiClass inner : inners) {
                if (processor2.execute(inner, substitutor2)) continue;
                return false;
            }
        } else {
            LOG.error(target);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(17);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitJavaFile(this);
        } else {
            visitor2.visitFile(this);
        }
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(18);
        }
        return javaLanguage;
    }

    @Override
    public boolean importClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(19);
        }
        return JavaCodeStyleManager.getInstance(this.getProject()).addImport(this, aClass);
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = LANGUAGE_LEVEL_KEY.getValue(this);
        if (languageLevel == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(20);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        return null;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.putUserData(LANGUAGE_LEVEL_KEY, null);
    }

    @Override
    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(21);
        }
        super.setOriginalFile(originalFile);
        this.clearCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LanguageLevel getLanguageLevelInner() {
        if (this.myOriginalFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
        }
        LanguageLevel forcedLanguageLevel = this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            return forcedLanguageLevel;
        }
        VirtualFile virtualFile2 = this.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        if (virtualFile2 == null) {
            virtualFile2 = this.getViewProvider().getVirtualFile();
        }
        String sourceLevel = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(virtualFile2.getInputStream(), StandardCharsets.UTF_8));){
            LanguageLevel sheBangLevel;
            List<String> params;
            int srcIdx;
            String line = reader.readLine();
            if (line != null && line.startsWith("#!") && (srcIdx = (params = ParametersListUtil.parse(line)).indexOf("--source")) > 0 && srcIdx + 1 < params.size() && (sheBangLevel = LanguageLevel.parse(sourceLevel = params.get(srcIdx + 1))) != null) {
                LanguageLevel languageLevel = sheBangLevel;
                return languageLevel;
            }
        }
        catch (Throwable file2) {
        }
        finally {
            if (!Objects.equals(sourceLevel, virtualFile2.getUserData(SHEBANG_SOURCE_LEVEL))) {
                virtualFile2.putUserData(SHEBANG_SOURCE_LEVEL, sourceLevel);
                VirtualFile file3 = virtualFile2;
                ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles(file3), ApplicationManager.getApplication().getDisposed());
            }
        }
        return JavaPsiImplementationHelper.getInstance(this.getProject()).getEffectiveLanguageLevel(virtualFile2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnDemandImports";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleClassImports";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackageReferences";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createRawSubstitutor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processOnDemandPackages";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDeclarations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "importClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setOriginalFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolveCacheProcessor
    implements Processor<SymbolCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        MyResolveCacheProcessor(PsiScopeProcessor processor2, ResolveState state) {
            this.myProcessor = processor2;
            this.myState = state;
        }

        @Override
        public boolean process(SymbolCollectingProcessor.ResultWithContext result2) {
            PsiClass containingClass;
            PsiElement context2 = result2.getFileContext();
            this.myProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, context2);
            PsiNamedElement element = result2.getElement();
            if (element instanceof PsiClass && context2 instanceof PsiImportStatement && (containingClass = ((PsiClass)element).getContainingClass()) != null && containingClass.hasTypeParameters()) {
                return this.myProcessor.execute(element, this.myState.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor(containingClass)));
            }
            return this.myProcessor.execute(element, this.myState);
        }
    }

    private static class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> {
        private final PsiJavaFileBaseImpl myFile;

        MyCacheBuilder(PsiJavaFileBaseImpl file2) {
            this.myFile = file2;
        }

        @Override
        public CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> compute() {
            SymbolCollectingProcessor p = new SymbolCollectingProcessor();
            this.myFile.processOnDemandPackages(p, ResolveState.initial(), this.myFile);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> results = p.getResults();
            return CachedValueProvider.Result.create(results, PsiModificationTracker.MODIFICATION_COUNT, this.myFile);
        }
    }

    private static class StaticImportFilteringProcessor
    extends DelegatingScopeProcessor {
        private final Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> myExplicitlyEnumerated;
        private final Collection<PsiElement> myCollectedElements = new HashSet<PsiElement>();

        StaticImportFilteringProcessor(PsiScopeProcessor delegate2, Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> explicitlyEnumerated) {
            super(delegate2);
            this.myExplicitlyEnumerated = explicitlyEnumerated;
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(0);
            }
            if (state == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                String name;
                Iterable<SymbolCollectingProcessor.ResultWithContext> shadowing;
                if (element instanceof PsiNamedElement && (shadowing = this.myExplicitlyEnumerated.get(name = ((PsiNamedElement)element).getName())) != null && ContainerUtil.exists(shadowing, rwc -> StaticImportFilteringProcessor.hasSameDeclarationKind(element, rwc.getElement()))) {
                    return true;
                }
                if (this.myCollectedElements.add(element)) {
                    return this.getDelegate().execute(element, state);
                }
            }
            return true;
        }

        private static boolean hasSameDeclarationKind(PsiElement e1, PsiElement e2) {
            return e1 instanceof PsiClass ? e2 instanceof PsiClass : (e1 instanceof PsiMethod ? e2 instanceof PsiMethod : e2 instanceof PsiField);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

