/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.LowerPriorityToPreserveCompatibilityDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u0001*\u0004\u0018\u00010\u0004H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0004H\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"isJavaApplicableCandidate", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "isSuperCall", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isSuperReferenceExpression", "markCandidateForCompatibilityResolve", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "resolve"})
public final class ResolutionStagesKt {
    private static final boolean isSuperCall(FirExpression $this$isSuperCall) {
        if (!($this$isSuperCall instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        return ((FirQualifiedAccessExpression)$this$isSuperCall).getCalleeReference() instanceof FirSuperReference;
    }

    private static final boolean isSuperReferenceExpression(FirExpression $this$isSuperReferenceExpression) {
        boolean bl;
        if ($this$isSuperReferenceExpression instanceof FirQualifiedAccessExpression) {
            FirReference calleeReference = ((FirQualifiedAccessExpression)$this$isSuperReferenceExpression).getCalleeReference();
            bl = calleeReference instanceof FirSuperReference;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isJavaApplicableCandidate(Candidate $this$isJavaApplicableCandidate) {
        FirBasedSymbol<?> firBasedSymbol = $this$isJavaApplicableCandidate.getSymbol();
        FirNamedFunctionSymbol firNamedFunctionSymbol = firBasedSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firBasedSymbol : null;
        if (firNamedFunctionSymbol == null) {
            return false;
        }
        FirNamedFunctionSymbol symbol2 = firNamedFunctionSymbol;
        if (Intrinsics.areEqual((Object)symbol2.getOrigin(), (Object)FirDeclarationOrigin.Enhancement.INSTANCE)) {
            return true;
        }
        if (!($this$isJavaApplicableCandidate.getOriginScope() instanceof FirTypeScope)) {
            return false;
        }
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions((FirTypeScope)$this$isJavaApplicableCandidate.getOriginScope(), symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(result2){
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol it) {
                ProcessorAction processorAction;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)it.getOrigin(), (Object)FirDeclarationOrigin.Enhancement.INSTANCE)) {
                    this.$result.element = true;
                    processorAction = ProcessorAction.STOP;
                } else {
                    processorAction = ProcessorAction.NEXT;
                }
                return processorAction;
            }
        }));
        return result2.element;
    }

    private static final void markCandidateForCompatibilityResolve(CheckerSink $this$markCandidateForCompatibilityResolve, ResolutionContext context2) {
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.DisableCompatibilityModeForNewInference)) {
            return;
        }
        $this$markCandidateForCompatibilityResolve.reportDiagnostic(LowerPriorityToPreserveCompatibilityDiagnostic.INSTANCE);
    }

    public static final /* synthetic */ boolean access$isSuperReferenceExpression(FirExpression $receiver) {
        return ResolutionStagesKt.isSuperReferenceExpression($receiver);
    }

    public static final /* synthetic */ boolean access$isSuperCall(FirExpression $receiver) {
        return ResolutionStagesKt.isSuperCall($receiver);
    }

    public static final /* synthetic */ boolean access$isJavaApplicableCandidate(Candidate $receiver) {
        return ResolutionStagesKt.isJavaApplicableCandidate($receiver);
    }

    public static final /* synthetic */ void access$markCandidateForCompatibilityResolve(CheckerSink $receiver, ResolutionContext context2) {
        ResolutionStagesKt.markCandidateForCompatibilityResolve($receiver, context2);
    }
}

