/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri.json;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.colibri.RTPLevelRelayType;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RemoteCandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpFbPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class JSONSerializer {
    static final String CANDIDATE_LIST = "candidates";
    static final String CHANNEL_BUNDLES = "channel-bundles";
    static final String ENDPOINTS = "endpoints";
    static final String CHANNELS = "channels";
    static final String CONTENTS = "contents";
    static final String FINGERPRINTS = "fingerprints";
    static final String PARAMETERS = "parameters";
    static final String PAYLOAD_TYPES = "payload-types";
    static final String RTCP_FBS = "rtcp-fbs";
    static final String SCTP_CONNECTIONS = "sctpconnections";
    static final String SOURCE_GROUPS = "ssrc-groups";
    static final String SOURCES = "sources";
    static final String SSRCS = "ssrcs";
    static final String RTP_HEADER_EXTS = "rtp-hdrexts";
    static final String WEBSOCKET_LIST = "web-sockets";
    static final String XMLNS = "xmlns";

    public static void serializeAbstractPacketExtensionAttributes(AbstractPacketExtension abstractPacketExtension, JSONObject jsonObject) {
        for (String name : abstractPacketExtension.getAttributeNames()) {
            Object value = abstractPacketExtension.getAttribute(name);
            if (value instanceof Enum) {
                value = value.toString();
            }
            jsonObject.put((Object)name, value);
        }
    }

    public static JSONObject serializeCandidate(CandidatePacketExtension candidate) {
        JSONObject candidateJSONObject;
        if (candidate == null) {
            candidateJSONObject = null;
        } else {
            candidateJSONObject = new JSONObject();
            JSONSerializer.serializeAbstractPacketExtensionAttributes(candidate, candidateJSONObject);
        }
        return candidateJSONObject;
    }

    public static JSONArray serializeCandidates(Collection<CandidatePacketExtension> candidates) {
        JSONArray candidatesJSONArray;
        if (candidates == null) {
            candidatesJSONArray = null;
        } else {
            candidatesJSONArray = new JSONArray();
            for (CandidatePacketExtension candidate : candidates) {
                candidatesJSONArray.add((Object)JSONSerializer.serializeCandidate(candidate));
            }
        }
        return candidatesJSONArray;
    }

    public static JSONObject serializeChannel(ColibriConferenceIQ.Channel channel) {
        JSONObject jsonObject;
        if (channel == null) {
            jsonObject = null;
        } else {
            String direction = channel.getDirection();
            Integer lastN = channel.getLastN();
            List<PayloadTypePacketExtension> payloadTypes = channel.getPayloadTypes();
            Collection<RTPHdrExtPacketExtension> rtpHdrExts = channel.getRtpHeaderExtensions();
            Integer receivingSimulcastStream = channel.getReceivingSimulcastLayer();
            RTPLevelRelayType rtpLevelRelayType = channel.getRTPLevelRelayType();
            List<SourcePacketExtension> sources = channel.getSources();
            List<SourceGroupPacketExtension> sourceGroups = channel.getSourceGroups();
            int[] ssrcs = channel.getSSRCs();
            jsonObject = JSONSerializer.serializeChannelCommon(channel);
            if (direction != null) {
                jsonObject.put((Object)"direction", (Object)direction);
            }
            if (lastN != null) {
                jsonObject.put((Object)"last-n", (Object)lastN);
            }
            if (lastN != null) {
                jsonObject.put((Object)"receive-simulcast-layer", (Object)receivingSimulcastStream);
            }
            if (payloadTypes != null && !payloadTypes.isEmpty()) {
                jsonObject.put((Object)PAYLOAD_TYPES, (Object)JSONSerializer.serializePayloadTypes(payloadTypes));
            }
            if (rtpHdrExts != null && !rtpHdrExts.isEmpty()) {
                jsonObject.put((Object)RTP_HEADER_EXTS, (Object)JSONSerializer.serializeRtpHdrExts(rtpHdrExts));
            }
            if (rtpLevelRelayType != null) {
                jsonObject.put((Object)"rtp-level-relay-type", (Object)rtpLevelRelayType.toString());
            }
            if (sources != null && !sources.isEmpty()) {
                jsonObject.put((Object)SOURCES, (Object)JSONSerializer.serializeSources(sources));
            }
            if (sourceGroups != null && !sourceGroups.isEmpty()) {
                jsonObject.put((Object)SOURCE_GROUPS, (Object)JSONSerializer.serializeSourceGroups(sourceGroups));
            }
            if (ssrcs != null && ssrcs.length > 0) {
                jsonObject.put((Object)SSRCS, (Object)JSONSerializer.serializeSSRCs(ssrcs));
            }
        }
        return jsonObject;
    }

    public static JSONObject serializeChannelBundle(ColibriConferenceIQ.ChannelBundle channelBundle) {
        JSONObject jsonObject;
        if (channelBundle == null) {
            jsonObject = null;
        } else {
            String id = channelBundle.getId();
            IceUdpTransportPacketExtension transport = channelBundle.getTransport();
            jsonObject = new JSONObject();
            if (id != null) {
                jsonObject.put((Object)"id", (Object)id);
            }
            if (transport != null) {
                jsonObject.put((Object)transport.getElementName(), (Object)JSONSerializer.serializeTransport(transport));
            }
        }
        return jsonObject;
    }

    public static JSONObject serializeEndpoint(ColibriConferenceIQ.Endpoint endpoint) {
        JSONObject jsonObject;
        if (endpoint == null) {
            jsonObject = null;
        } else {
            String id = endpoint.getId();
            String statsId = endpoint.getStatsId();
            jsonObject = new JSONObject();
            if (id != null) {
                jsonObject.put((Object)"id", (Object)id);
            }
            if (statsId != null) {
                jsonObject.put((Object)"stats-id", (Object)statsId);
            }
        }
        return jsonObject;
    }

    public static JSONArray serializeChannelBundles(Collection<ColibriConferenceIQ.ChannelBundle> channelBundles) {
        JSONArray jsonArray;
        if (channelBundles == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.ChannelBundle channelBundle : channelBundles) {
                jsonArray.add((Object)JSONSerializer.serializeChannelBundle(channelBundle));
            }
        }
        return jsonArray;
    }

    public static JSONArray serializeEndpoints(Collection<ColibriConferenceIQ.Endpoint> endpoints) {
        JSONArray jsonArray;
        if (endpoints == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.Endpoint endpoint : endpoints) {
                jsonArray.add((Object)JSONSerializer.serializeEndpoint(endpoint));
            }
        }
        return jsonArray;
    }

    public static JSONObject serializeChannelCommon(ColibriConferenceIQ.ChannelCommon channelCommon) {
        JSONObject jsonObject;
        if (channelCommon == null) {
            jsonObject = null;
        } else {
            String id = channelCommon.getID();
            String channelBundleId = channelCommon.getChannelBundleId();
            String endpoint = channelCommon.getEndpoint();
            int expire = channelCommon.getExpire();
            Boolean initiator = channelCommon.isInitiator();
            IceUdpTransportPacketExtension transport = channelCommon.getTransport();
            jsonObject = new JSONObject();
            if (id != null) {
                jsonObject.put((Object)"id", (Object)id);
            }
            if (channelBundleId != null) {
                jsonObject.put((Object)"channel-bundle-id", (Object)channelBundleId);
            }
            if (endpoint != null) {
                jsonObject.put((Object)"endpoint", (Object)endpoint);
            }
            if (expire >= 0) {
                jsonObject.put((Object)"expire", (Object)expire);
            }
            if (initiator != null) {
                jsonObject.put((Object)"initiator", (Object)initiator);
            }
            if (transport != null) {
                jsonObject.put((Object)transport.getElementName(), (Object)JSONSerializer.serializeTransport(transport));
            }
        }
        return jsonObject;
    }

    public static JSONArray serializeChannels(Collection<ColibriConferenceIQ.Channel> collection) {
        JSONArray jsonArray;
        if (collection == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.Channel element : collection) {
                jsonArray.add((Object)JSONSerializer.serializeChannel(element));
            }
        }
        return jsonArray;
    }

    public static JSONObject serializeConference(ColibriConferenceIQ conference) {
        JSONObject jsonObject;
        if (conference == null) {
            jsonObject = null;
        } else {
            String id = conference.getID();
            List<ColibriConferenceIQ.Content> contents = conference.getContents();
            List<ColibriConferenceIQ.ChannelBundle> channelBundles = conference.getChannelBundles();
            List<ColibriConferenceIQ.Endpoint> endpoints = conference.getEndpoints();
            boolean isGracefulShutdown = conference.isGracefulShutdown();
            jsonObject = new JSONObject();
            if (id != null) {
                jsonObject.put((Object)"id", (Object)id);
            }
            if (contents != null && !contents.isEmpty()) {
                jsonObject.put((Object)CONTENTS, (Object)JSONSerializer.serializeContents(contents));
            }
            if (channelBundles != null && !channelBundles.isEmpty()) {
                jsonObject.put((Object)CHANNEL_BUNDLES, (Object)JSONSerializer.serializeChannelBundles(channelBundles));
            }
            if (endpoints != null && !endpoints.isEmpty()) {
                jsonObject.put((Object)ENDPOINTS, (Object)JSONSerializer.serializeEndpoints(endpoints));
            }
            if (isGracefulShutdown) {
                jsonObject.put((Object)"graceful-shutdown", (Object)"true");
            }
        }
        return jsonObject;
    }

    public static JSONArray serializeConferences(Collection<ColibriConferenceIQ> conferences) {
        JSONArray conferencesJSONArray;
        if (conferences == null) {
            conferencesJSONArray = null;
        } else {
            conferencesJSONArray = new JSONArray();
            for (ColibriConferenceIQ conference : conferences) {
                conferencesJSONArray.add((Object)JSONSerializer.serializeConference(conference));
            }
        }
        return conferencesJSONArray;
    }

    public static JSONObject serializeContent(ColibriConferenceIQ.Content content) {
        JSONObject jsonObject;
        if (content == null) {
            jsonObject = null;
        } else {
            String name = content.getName();
            List<ColibriConferenceIQ.Channel> channels = content.getChannels();
            List<ColibriConferenceIQ.SctpConnection> sctpConnections = content.getSctpConnections();
            jsonObject = new JSONObject();
            if (name != null) {
                jsonObject.put((Object)"name", (Object)name);
            }
            if (channels != null && !channels.isEmpty()) {
                jsonObject.put((Object)CHANNELS, (Object)JSONSerializer.serializeChannels(channels));
            }
            if (sctpConnections != null && !sctpConnections.isEmpty()) {
                jsonObject.put((Object)SCTP_CONNECTIONS, (Object)JSONSerializer.serializeSctpConnections(sctpConnections));
            }
        }
        return jsonObject;
    }

    public static JSONArray serializeContents(Collection<ColibriConferenceIQ.Content> contents) {
        JSONArray jsonArray;
        if (contents == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.Content content : contents) {
                jsonArray.add((Object)JSONSerializer.serializeContent(content));
            }
        }
        return jsonArray;
    }

    public static JSONObject serializeFingerprint(DtlsFingerprintPacketExtension fingerprint) {
        JSONObject fingerprintJSONObject;
        if (fingerprint == null) {
            fingerprintJSONObject = null;
        } else {
            String theFingerprint = fingerprint.getFingerprint();
            fingerprintJSONObject = new JSONObject();
            if (theFingerprint != null) {
                fingerprintJSONObject.put((Object)fingerprint.getElementName(), (Object)theFingerprint);
            }
            JSONSerializer.serializeAbstractPacketExtensionAttributes(fingerprint, fingerprintJSONObject);
        }
        return fingerprintJSONObject;
    }

    public static JSONArray serializeFingerprints(Collection<DtlsFingerprintPacketExtension> fingerprints) {
        JSONArray fingerprintsJSONArray;
        if (fingerprints == null) {
            fingerprintsJSONArray = null;
        } else {
            fingerprintsJSONArray = new JSONArray();
            for (DtlsFingerprintPacketExtension fingerprint : fingerprints) {
                fingerprintsJSONArray.add((Object)JSONSerializer.serializeFingerprint(fingerprint));
            }
        }
        return fingerprintsJSONArray;
    }

    public static JSONObject serializeParameters(Collection<ParameterPacketExtension> parameters) {
        JSONObject parametersJSONObject;
        if (parameters == null) {
            parametersJSONObject = null;
        } else {
            parametersJSONObject = new JSONObject();
            for (ParameterPacketExtension parameter : parameters) {
                String name = parameter.getName();
                String value = parameter.getValue();
                if (name == null && value == null) continue;
                parametersJSONObject.put((Object)name, (Object)value);
            }
        }
        return parametersJSONObject;
    }

    public static JSONArray serializeRtcpFbs(@NotNull Collection<RtcpFbPacketExtension> rtcpFbs) {
        JSONArray rtcpFbsJSON = new JSONArray();
        for (RtcpFbPacketExtension ext : rtcpFbs) {
            String type = ext.getFeedbackType();
            String subtype = ext.getFeedbackSubtype();
            if (type == null) continue;
            JSONObject rtcpFbJSON = new JSONObject();
            rtcpFbJSON.put((Object)"type", (Object)type);
            if (subtype != null) {
                rtcpFbJSON.put((Object)"subtype", (Object)subtype);
            }
            rtcpFbsJSON.add((Object)rtcpFbJSON);
        }
        return rtcpFbsJSON;
    }

    public static JSONObject serializePayloadType(PayloadTypePacketExtension payloadType) {
        JSONObject payloadTypeJSONObject;
        if (payloadType == null) {
            payloadTypeJSONObject = null;
        } else {
            List<RtcpFbPacketExtension> rtcpFeedbackTypeList;
            List<ParameterPacketExtension> parameters = payloadType.getParameters();
            payloadTypeJSONObject = new JSONObject();
            JSONSerializer.serializeAbstractPacketExtensionAttributes(payloadType, payloadTypeJSONObject);
            if (parameters != null && !parameters.isEmpty()) {
                payloadTypeJSONObject.put((Object)PARAMETERS, (Object)JSONSerializer.serializeParameters(parameters));
            }
            if ((rtcpFeedbackTypeList = payloadType.getRtcpFeedbackTypeList()) != null && !rtcpFeedbackTypeList.isEmpty()) {
                payloadTypeJSONObject.put((Object)RTCP_FBS, (Object)JSONSerializer.serializeRtcpFbs(rtcpFeedbackTypeList));
            }
        }
        return payloadTypeJSONObject;
    }

    public static JSONArray serializePayloadTypes(Collection<PayloadTypePacketExtension> payloadTypes) {
        JSONArray payloadTypesJSONArray;
        if (payloadTypes == null) {
            payloadTypesJSONArray = null;
        } else {
            payloadTypesJSONArray = new JSONArray();
            for (PayloadTypePacketExtension payloadType : payloadTypes) {
                payloadTypesJSONArray.add((Object)JSONSerializer.serializePayloadType(payloadType));
            }
        }
        return payloadTypesJSONArray;
    }

    public static JSONObject serializeRtpHdrExt(RTPHdrExtPacketExtension rtpHdrExt) {
        JSONObject rtpHdrExtJSONObject;
        if (rtpHdrExt == null) {
            rtpHdrExtJSONObject = null;
        } else {
            String attributes;
            ContentPacketExtension.SendersEnum senders;
            URI uri;
            rtpHdrExtJSONObject = new JSONObject();
            String id = rtpHdrExt.getID();
            if (id != null) {
                rtpHdrExtJSONObject.put((Object)"id", (Object)Long.valueOf(id));
            }
            if ((uri = rtpHdrExt.getURI()) != null) {
                rtpHdrExtJSONObject.put((Object)"uri", (Object)uri.toString());
            }
            if ((senders = rtpHdrExt.getSenders()) != null) {
                rtpHdrExtJSONObject.put((Object)"senders", (Object)senders.toString());
            }
            if ((attributes = rtpHdrExt.getAttributes()) != null) {
                rtpHdrExtJSONObject.put((Object)"attributes", (Object)attributes);
            }
        }
        return rtpHdrExtJSONObject;
    }

    public static JSONArray serializeRtpHdrExts(Collection<RTPHdrExtPacketExtension> rtpHdrExts) {
        JSONArray rtpHdrExtsJSONArray;
        if (rtpHdrExts == null) {
            rtpHdrExtsJSONArray = null;
        } else {
            rtpHdrExtsJSONArray = new JSONArray();
            for (RTPHdrExtPacketExtension rtpHdrExt : rtpHdrExts) {
                rtpHdrExtsJSONArray.add((Object)JSONSerializer.serializeRtpHdrExt(rtpHdrExt));
            }
        }
        return rtpHdrExtsJSONArray;
    }

    public static JSONObject serializeSctpConnection(ColibriConferenceIQ.SctpConnection sctpConnection) {
        JSONObject jsonObject;
        if (sctpConnection == null) {
            jsonObject = null;
        } else {
            int port = sctpConnection.getPort();
            jsonObject = JSONSerializer.serializeChannelCommon(sctpConnection);
            jsonObject.put((Object)"port", (Object)port);
        }
        return jsonObject;
    }

    public static JSONArray serializeSctpConnections(Collection<ColibriConferenceIQ.SctpConnection> collection) {
        JSONArray jsonArray;
        if (collection == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.SctpConnection element : collection) {
                jsonArray.add((Object)JSONSerializer.serializeSctpConnection(element));
            }
        }
        return jsonArray;
    }

    public static Object serializeSource(SourcePacketExtension source) {
        if (source == null) {
            return null;
        }
        String name = source.getName();
        String videoType = source.getVideoType();
        String rid = source.getRid();
        List<ParameterPacketExtension> parameters = source.getParameters();
        if (name == null && rid == null && parameters.isEmpty()) {
            return source.getSSRC();
        }
        JSONObject sourceJSONObject = new JSONObject();
        sourceJSONObject.put((Object)"ssrc", (Object)source.getSSRC());
        if (name != null) {
            sourceJSONObject.put((Object)"name", (Object)name);
        }
        if (videoType != null) {
            sourceJSONObject.put((Object)"videoType", (Object)videoType);
        }
        if (rid != null) {
            sourceJSONObject.put((Object)"rid", (Object)rid);
        }
        if (!parameters.isEmpty()) {
            sourceJSONObject.put((Object)PARAMETERS, (Object)JSONSerializer.serializeParameters(parameters));
        }
        return sourceJSONObject;
    }

    private static Object serializeSourceGroup(SourceGroupPacketExtension sourceGroup) {
        if (sourceGroup.getSemantics() != null && sourceGroup.getSemantics().length() != 0 && sourceGroup.getSources() != null && sourceGroup.getSources().size() != 0) {
            JSONObject sourceGroupJSONObject = new JSONObject();
            sourceGroupJSONObject.put((Object)"semantics", (Object)JSONValue.escape((String)sourceGroup.getSemantics()));
            JSONArray ssrcsJSONArray = new JSONArray();
            for (SourcePacketExtension source : sourceGroup.getSources()) {
                ssrcsJSONArray.add((Object)source.getSSRC());
            }
            sourceGroupJSONObject.put((Object)SOURCES, (Object)ssrcsJSONArray);
            return sourceGroupJSONObject;
        }
        return null;
    }

    public static JSONArray serializeSourceGroups(Collection<SourceGroupPacketExtension> sourceGroups) {
        JSONArray sourceGroupsJSONArray;
        if (sourceGroups == null || sourceGroups.size() == 0) {
            sourceGroupsJSONArray = null;
        } else {
            sourceGroupsJSONArray = new JSONArray();
            for (SourceGroupPacketExtension sourceGroup : sourceGroups) {
                sourceGroupsJSONArray.add(JSONSerializer.serializeSourceGroup(sourceGroup));
            }
        }
        return sourceGroupsJSONArray;
    }

    public static JSONArray serializeSources(Collection<SourcePacketExtension> sources) {
        JSONArray sourcesJSONArray;
        if (sources == null) {
            sourcesJSONArray = null;
        } else {
            sourcesJSONArray = new JSONArray();
            for (SourcePacketExtension source : sources) {
                sourcesJSONArray.add(JSONSerializer.serializeSource(source));
            }
        }
        return sourcesJSONArray;
    }

    public static JSONArray serializeSSRCs(int[] ssrcs) {
        JSONArray ssrcsJSONArray;
        if (ssrcs == null) {
            ssrcsJSONArray = null;
        } else {
            ssrcsJSONArray = new JSONArray();
            for (int i = 0; i < ssrcs.length; ++i) {
                ssrcsJSONArray.add((Object)((long)ssrcs[i] & 0xFFFFFFFFL));
            }
        }
        return ssrcsJSONArray;
    }

    public static JSONObject serializeTransport(IceUdpTransportPacketExtension transport) {
        JSONObject jsonObject;
        if (transport == null) {
            jsonObject = null;
        } else {
            String xmlns = transport.getNamespace();
            List<DtlsFingerprintPacketExtension> fingerprints = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
            List<CandidatePacketExtension> candidateList = transport.getCandidateList();
            List<WebSocketPacketExtension> webSocketList = transport.getChildExtensionsOfType(WebSocketPacketExtension.class);
            RemoteCandidatePacketExtension remoteCandidate = transport.getRemoteCandidate();
            boolean rtcpMux = transport.isRtcpMux();
            jsonObject = new JSONObject();
            if (xmlns != null) {
                jsonObject.put((Object)XMLNS, (Object)xmlns);
            }
            JSONSerializer.serializeAbstractPacketExtensionAttributes(transport, jsonObject);
            if (fingerprints != null && !fingerprints.isEmpty()) {
                jsonObject.put((Object)FINGERPRINTS, (Object)JSONSerializer.serializeFingerprints(fingerprints));
            }
            if (candidateList != null && !candidateList.isEmpty()) {
                jsonObject.put((Object)CANDIDATE_LIST, (Object)JSONSerializer.serializeCandidates(candidateList));
            }
            if (remoteCandidate != null) {
                jsonObject.put((Object)remoteCandidate.getElementName(), (Object)JSONSerializer.serializeCandidate(remoteCandidate));
            }
            if (webSocketList != null && !webSocketList.isEmpty()) {
                jsonObject.put((Object)WEBSOCKET_LIST, (Object)JSONSerializer.serializeWebSockets(webSocketList));
            }
            if (rtcpMux) {
                jsonObject.put((Object)"rtcp-mux", (Object)Boolean.TRUE);
            }
        }
        return jsonObject;
    }

    private static String serializeWebSocket(WebSocketPacketExtension webSocket) {
        if (webSocket.getActive()) {
            return "active";
        }
        return webSocket.getUrl();
    }

    private static JSONArray serializeWebSockets(List<WebSocketPacketExtension> webSocketList) {
        JSONArray webSocketsJSONArray;
        if (webSocketList == null) {
            webSocketsJSONArray = null;
        } else {
            webSocketsJSONArray = new JSONArray();
            for (WebSocketPacketExtension webSocket : webSocketList) {
                webSocketsJSONArray.add((Object)JSONSerializer.serializeWebSocket(webSocket));
            }
        }
        return webSocketsJSONArray;
    }

    private JSONSerializer() {
    }
}

