/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp.rce;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.tcp.rce.IpTcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.tcp.rce.SrvXmppRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpoint;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;
import org.minidns.dnsname.DnsName;
import org.minidns.record.InternetAddressRR;
import org.minidns.record.SRV;
import org.minidns.util.SrvUtil;

public class RemoteXmppTcpConnectionEndpoints {
    private static final Logger LOGGER = Logger.getLogger(RemoteXmppTcpConnectionEndpoints.class.getName());
    public static final String XMPP_CLIENT_DNS_SRV_PREFIX = "_xmpp-client._tcp";
    public static final String XMPP_SERVER_DNS_SRV_PREFIX = "_xmpp-server._tcp";

    public static Result<Rfc6120TcpRemoteConnectionEndpoint> lookup(ConnectionConfiguration config) {
        List<Rfc6120TcpRemoteConnectionEndpoint> discoveredRemoteConnectionEndpoints;
        List<RemoteConnectionEndpointLookupFailure> lookupFailures;
        InetAddress hostAddress = config.getHostAddress();
        DnsName host = config.getHost();
        if (hostAddress != null) {
            lookupFailures = Collections.emptyList();
            IpTcpRemoteConnectionEndpoint<InternetAddressRR<?>> connectionEndpoint = IpTcpRemoteConnectionEndpoint.from(hostAddress.toString(), config.getPort(), hostAddress);
            discoveredRemoteConnectionEndpoints = Collections.singletonList(connectionEndpoint);
        } else if (host != null) {
            lookupFailures = new ArrayList(1);
            List hostAddresses = DNSUtil.getDNSResolver().lookupHostAddress(host, lookupFailures, config.getDnssecMode());
            if (hostAddresses != null) {
                discoveredRemoteConnectionEndpoints = new ArrayList(hostAddresses.size());
                UInt16 port = config.getPort();
                for (InetAddress inetAddress : hostAddresses) {
                    IpTcpRemoteConnectionEndpoint<InternetAddressRR<?>> connectionEndpoint = IpTcpRemoteConnectionEndpoint.from((CharSequence)host, port, inetAddress);
                    discoveredRemoteConnectionEndpoints.add(connectionEndpoint);
                }
            } else {
                discoveredRemoteConnectionEndpoints = Collections.emptyList();
            }
        } else {
            lookupFailures = new ArrayList();
            DnsName dnsName = config.getXmppServiceDomainAsDnsNameIfPossible();
            if (dnsName == null) {
                throw new IllegalStateException();
            }
            discoveredRemoteConnectionEndpoints = RemoteXmppTcpConnectionEndpoints.resolveXmppServiceDomain(dnsName, lookupFailures, config.getDnssecMode());
        }
        assert (!discoveredRemoteConnectionEndpoints.isEmpty() || !lookupFailures.isEmpty());
        return new Result<Rfc6120TcpRemoteConnectionEndpoint>(discoveredRemoteConnectionEndpoints, lookupFailures);
    }

    public static List<Rfc6120TcpRemoteConnectionEndpoint> resolveXmppServiceDomain(DnsName domain, List<RemoteConnectionEndpointLookupFailure> lookupFailures, ConnectionConfiguration.DnssecMode dnssecMode) {
        DNSResolver dnsResolver = RemoteXmppTcpConnectionEndpoints.getDnsResolverOrThrow();
        return RemoteXmppTcpConnectionEndpoints.resolveDomain(domain, DomainType.client, lookupFailures, dnssecMode, dnsResolver);
    }

    public static List<Rfc6120TcpRemoteConnectionEndpoint> resolveXmppServerDomain(DnsName domain, List<RemoteConnectionEndpointLookupFailure> lookupFailures, ConnectionConfiguration.DnssecMode dnssecMode) {
        DNSResolver dnsResolver = RemoteXmppTcpConnectionEndpoints.getDnsResolverOrThrow();
        return RemoteXmppTcpConnectionEndpoints.resolveDomain(domain, DomainType.server, lookupFailures, dnssecMode, dnsResolver);
    }

    private static List<Rfc6120TcpRemoteConnectionEndpoint> resolveDomain(DnsName domain, DomainType domainType, List<RemoteConnectionEndpointLookupFailure> lookupFailures, ConnectionConfiguration.DnssecMode dnssecMode, DNSResolver dnsResolver) {
        UInt16 defaultPort;
        Rfc6120TcpRemoteConnectionEndpoint endpoint;
        ArrayList<Rfc6120TcpRemoteConnectionEndpoint> endpoints = new ArrayList<Rfc6120TcpRemoteConnectionEndpoint>();
        DnsName srvDomain = DnsName.from((DnsName)domainType.srvPrefix, (DnsName)domain);
        Collection srvRecords = dnsResolver.lookupSrvRecords(srvDomain, lookupFailures, dnssecMode);
        if (srvRecords != null && !srvRecords.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                String logMessage = "Resolved SRV RR for " + srvDomain + ":";
                for (SRV r : srvRecords) {
                    logMessage = logMessage + " " + r;
                }
                LOGGER.fine(logMessage);
            }
            List sortedSrvRecords = SrvUtil.sortSrvRecords((Collection)srvRecords);
            for (SRV srv : sortedSrvRecords) {
                List targetInetAddresses = dnsResolver.lookupHostAddress(srv.target, lookupFailures, dnssecMode);
                if (targetInetAddresses == null) continue;
                endpoint = new SrvXmppRemoteConnectionEndpoint(srv, targetInetAddresses);
                endpoints.add(endpoint);
            }
        } else {
            LOGGER.info("Could not resolve DNS SRV resource records for " + srvDomain + ". Consider adding those.");
        }
        switch (domainType) {
            case client: {
                defaultPort = UInt16.from((int)5222);
                break;
            }
            case server: {
                defaultPort = UInt16.from((int)5269);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        List hostAddresses = dnsResolver.lookupHostAddress(domain, lookupFailures, dnssecMode);
        if (hostAddresses != null) {
            for (InetAddress inetAddress : hostAddresses) {
                endpoint = IpTcpRemoteConnectionEndpoint.from((CharSequence)domain, defaultPort, inetAddress);
                endpoints.add(endpoint);
            }
        }
        return endpoints;
    }

    private static DNSResolver getDnsResolverOrThrow() {
        DNSResolver dnsResolver = DNSUtil.getDNSResolver();
        if (dnsResolver == null) {
            throw new IllegalStateException("No DNS resolver configured in Smack");
        }
        return dnsResolver;
    }

    static enum DomainType {
        server("_xmpp-server._tcp"),
        client("_xmpp-client._tcp");

        public final DnsName srvPrefix;

        private DomainType(String srvPrefixString) {
            this.srvPrefix = DnsName.from((String)srvPrefixString);
        }
    }

    public static final class Result<RCE extends RemoteConnectionEndpoint> {
        public final List<RCE> discoveredRemoteConnectionEndpoints;
        public final List<RemoteConnectionEndpointLookupFailure> lookupFailures;

        private Result(List<RCE> discoveredRemoteConnectionEndpoints, List<RemoteConnectionEndpointLookupFailure> lookupFailures) {
            this.discoveredRemoteConnectionEndpoints = discoveredRemoteConnectionEndpoints;
            this.lookupFailures = lookupFailures;
        }
    }
}

