/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.rest;

import java.net.MalformedURLException;
import java.net.URL;
import org.sonatype.nexus.client.internal.util.Check;
import org.sonatype.nexus.client.rest.Protocol;

public class BaseUrl {
    private final Protocol protocol;
    private final String host;
    private final int port;
    private final String path;

    public BaseUrl(Protocol protocol, String host, int port, String path) {
        this.protocol = Check.notNull(protocol, Protocol.class);
        this.host = Check.notBlank(host, "host");
        this.port = Check.argument(port > 0 && port < 65536, port, "Port out of boundaries (0 < port < 65536)!");
        String fixedPath = path;
        if (!fixedPath.endsWith("/")) {
            fixedPath = fixedPath + "/";
        }
        this.path = fixedPath;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String toUrl() {
        return this.getProtocol().name().toLowerCase() + "://" + this.getHost() + ":" + this.getPort() + this.getPath();
    }

    public String toString() {
        return this.toUrl();
    }

    public static BaseUrl baseUrlFrom(String url) throws MalformedURLException {
        return BaseUrl.baseUrlFrom(new URL(Check.notBlank(url, "URL")));
    }

    public static BaseUrl baseUrlFrom(URL url) {
        Check.notNull(url, URL.class);
        Protocol protocol = Protocol.valueOf(url.getProtocol().toUpperCase());
        String host = url.getHost();
        int port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        String fixedPath = url.getPath();
        if (!fixedPath.startsWith("/")) {
            fixedPath = "/" + fixedPath;
        }
        if (!fixedPath.endsWith("/")) {
            fixedPath = fixedPath + "/";
        }
        return new BaseUrl(protocol, host, port, fixedPath);
    }
}

