/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.delay.provider;

import java.io.IOException;
import java.util.Date;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.delay.packet.DelayInformation;

public abstract class AbstractDelayInformationProvider
extends ExtensionElementProvider<DelayInformation> {
    public final DelayInformation parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException.SmackTextParseException {
        String reason;
        String stampString = parser.getAttributeValue("", "stamp");
        String from = parser.getAttributeValue("", "from");
        XmlPullParser.Event event = parser.next();
        switch (event) {
            case TEXT_CHARACTERS: {
                reason = parser.getText();
                parser.next();
                break;
            }
            case END_ELEMENT: {
                reason = null;
                break;
            }
            default: {
                throw new IOException("Unexpected event: " + event);
            }
        }
        Date stamp = this.parseDate(stampString);
        return new DelayInformation(stamp, from, reason);
    }

    protected abstract Date parseDate(String var1) throws SmackParsingException.SmackTextParseException;
}

