/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.plugins.enforcer.utils.DistributionManagementCheck;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class BanDistributionManagement
extends AbstractNonCacheableEnforcerRule {
    private boolean allowRepository = false;
    private boolean allowSnapshotRepository = false;
    private boolean allowSite = false;
    private Log logger;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        this.logger = helper.getLog();
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            if (project.isExecutionRoot()) {
                if (project.getParent() == null) {
                    this.logger.debug((CharSequence)"We have no parent and in the root of a build we don't check anything,");
                    this.logger.debug((CharSequence)"because that is the location where we defined maven-enforcer-plugin.");
                } else {
                    this.logger.debug((CharSequence)"We are in the root of the execution and we have a parent.");
                    DistributionManagementCheck check = new DistributionManagementCheck(project);
                    check.execute(this.isAllowRepository(), this.isAllowSnapshotRepository(), this.isAllowSite());
                }
            } else {
                this.logger.debug((CharSequence)"We are in a deeper level.");
                DistributionManagementCheck check = new DistributionManagementCheck(project);
                check.execute(this.isAllowRepository(), this.isAllowSnapshotRepository(), this.isAllowSite());
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public boolean isAllowRepository() {
        return this.allowRepository;
    }

    public void setAllowRepository(boolean allowRepository) {
        this.allowRepository = allowRepository;
    }

    public boolean isAllowSnapshotRepository() {
        return this.allowSnapshotRepository;
    }

    public void setAllowSnapshotRepository(boolean allowSnapshotRepository) {
        this.allowSnapshotRepository = allowSnapshotRepository;
    }

    public boolean isAllowSite() {
        return this.allowSite;
    }

    public void setAllowSite(boolean allowSite) {
        this.allowSite = allowSite;
    }
}

