/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.util;

public class Template {
    private final String format;
    private final Object[] args;

    public Template(String format, Object ... args) {
        if (format == null || format.trim().isEmpty()) {
            throw new IllegalArgumentException("Template's format cannot be blank!");
        }
        this.format = format;
        this.args = args;
    }

    public String evaluate() {
        return String.format(this.format, this.args);
    }

    public String getFormat() {
        return this.format;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String toString() {
        return this.evaluate();
    }

    public static Template of(String format, Object ... args) {
        return new Template(format, args);
    }
}

