/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.client.internal;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.sonatype.nexus.staging.api.dto.StagingProfileDTO;
import com.sonatype.nexus.staging.api.dto.StagingProfileListResponseDTO;
import com.sonatype.nexus.staging.api.dto.StagingProfileResponseDTO;
import com.sonatype.nexus.staging.api.dto.StagingXStreamConfigurator;
import com.sonatype.nexus.staging.client.Profile;
import com.sonatype.nexus.staging.client.StagingProfiles;
import com.sonatype.nexus.staging.client.internal.JerseyStagingProfile;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.client.core.NexusClient;
import org.sonatype.nexus.client.core.spi.SubsystemSupport;
import org.sonatype.nexus.client.rest.jersey.ContextAwareUniformInterfaceException;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;

public class JerseyStagingProfiles
extends SubsystemSupport<JerseyNexusClient>
implements StagingProfiles {
    public JerseyStagingProfiles(JerseyNexusClient nexusClient) {
        super((NexusClient)nexusClient);
        StagingXStreamConfigurator.configureXStream(nexusClient.getXStream());
    }

    public Profile create(String id) {
        if (id != null) {
            throw new IllegalArgumentException("Profile id is automatically generated. Use 'null' or the other create method");
        }
        return this.create();
    }

    @Override
    public Profile create() {
        return new JerseyStagingProfile((JerseyNexusClient)this.getNexusClient());
    }

    public Profile get(String id) {
        try {
            return this.convert(((StagingProfileResponseDTO)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyStagingProfiles.path(id)).get(StagingProfileResponseDTO.class)).getData());
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert((UniformInterfaceException)((Object)new StagingProfileNotFoundException(e.getResponse(), id)));
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    public Collection<Profile> get() {
        StagingProfileListResponseDTO profiles;
        try {
            profiles = (StagingProfileListResponseDTO)((JerseyNexusClient)this.getNexusClient()).serviceResource("staging/profiles").get(StagingProfileListResponseDTO.class);
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        return Collections2.transform(profiles.getData(), (Function)new Function<StagingProfileDTO, Profile>(){

            public Profile apply(@Nullable StagingProfileDTO input) {
                return JerseyStagingProfiles.this.convert(input);
            }
        });
    }

    private JerseyStagingProfile convert(@Nullable StagingProfileDTO resource) {
        if (resource == null) {
            return null;
        }
        JerseyStagingProfile stagingProfile = new JerseyStagingProfile((JerseyNexusClient)this.getNexusClient(), resource);
        stagingProfile.overwriteWith(resource);
        return stagingProfile;
    }

    public static String path(String id) {
        try {
            return "staging/profiles/" + URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static class StagingProfileNotFoundException
    extends ContextAwareUniformInterfaceException {
        private String id;

        StagingProfileNotFoundException(ClientResponse response, String id) {
            super(response);
            this.id = id;
        }

        public String getMessage(int status) {
            if (status == Response.Status.NOT_FOUND.getStatusCode()) {
                return String.format("Staging profile with id '%s' was not found", this.id);
            }
            return null;
        }
    }
}

