/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.impl.SipResponseBuilder;

public interface SipResponse
extends SipMessage {
    public int getStatus();

    public Buffer getReasonPhrase();

    @Override
    default public boolean isResponse() {
        return true;
    }

    @Override
    default public boolean isError() {
        return this.getStatus() / 100 >= 4;
    }

    @Override
    default public boolean isProvisional() {
        return this.getStatus() / 100 == 1;
    }

    @Override
    default public boolean isFinal() {
        return this.getStatus() >= 200;
    }

    @Override
    default public boolean isSuccess() {
        return this.getStatus() / 100 == 2;
    }

    @Override
    default public boolean isRedirect() {
        return this.getStatus() / 100 == 3;
    }

    @Override
    default public boolean isClientError() {
        return this.getStatus() / 100 == 4;
    }

    @Override
    default public boolean isServerError() {
        return this.getStatus() / 100 == 5;
    }

    @Override
    default public boolean isGlobalError() {
        return this.getStatus() / 100 == 6;
    }

    @Override
    default public boolean is100Trying() {
        return this.getStatus() == 100;
    }

    @Override
    default public boolean isRinging() {
        return this.getStatus() == 180 || this.getStatus() == 183;
    }

    public static Builder withStatusCode(int statusCode) {
        return new SipResponseBuilder(statusCode);
    }

    @Override
    default public boolean isTimeout() {
        return this.getStatus() == 480;
    }

    @Override
    default public SipResponse toResponse() throws ClassCastException {
        return this;
    }

    public Builder copy();

    @Override
    public SipResponse clone();

    public static interface Builder
    extends SipMessage.Builder<SipResponse> {
        @Override
        default public SipMessage.Builder<SipResponse> toSipResponseBuilder() {
            return this;
        }

        @Override
        default public boolean isSipResponseBuilder() {
            return true;
        }

        public Builder withReasonPhrase(String var1);

        public Builder withReasonPhrase(Buffer var1);

        @Override
        public SipResponse build();
    }
}

