/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.impl.SipParser;

public enum Transport {
    udp(Buffers.wrap((String)"udp"), false),
    tcp(Buffers.wrap((String)"tcp"), true),
    tls(Buffers.wrap((String)"tls"), true),
    sctp(Buffers.wrap((String)"sctp"), true),
    ws(Buffers.wrap((String)"ws"), true),
    wss(Buffers.wrap((String)"wss"), true);

    final Buffer buffer;
    final Buffer upperCaseBuffer;
    final boolean isReliable;

    private Transport(Buffer buffer, boolean isReliable) {
        this.buffer = buffer;
        this.upperCaseBuffer = Buffers.wrap((String)buffer.toString().toUpperCase());
        this.isReliable = isReliable;
    }

    public boolean isReliable() {
        return this.isReliable;
    }

    public boolean isUDP() {
        return this == udp;
    }

    public boolean isTCP() {
        return this == tcp;
    }

    public boolean isTLS() {
        return this == tls;
    }

    public boolean isSCTP() {
        return this == sctp;
    }

    public boolean isWS() {
        return this == ws;
    }

    public boolean isWSS() {
        return this == wss;
    }

    public static Transport of(Buffer buffer) throws IllegalArgumentException {
        if (buffer == null || buffer.isEmpty()) {
            throw new IllegalArgumentException("Illegal Transport - the transport buffer cannot be null or empty");
        }
        if (SipParser.isUDP(buffer) || SipParser.isUDPLower(buffer)) {
            return udp;
        }
        if (SipParser.isTCP(buffer) || SipParser.isTCPLower(buffer)) {
            return tcp;
        }
        if (SipParser.isTLS(buffer) || SipParser.isTLSLower(buffer)) {
            return tls;
        }
        if (SipParser.isSCTP(buffer) || SipParser.isSCTPLower(buffer)) {
            return sctp;
        }
        if (SipParser.isWS(buffer) || SipParser.isWSLower(buffer)) {
            return ws;
        }
        if (SipParser.isWSS(buffer) || SipParser.isWSSLower(buffer)) {
            return wss;
        }
        throw new IllegalArgumentException("Illegal Transport - Unknown transport \"" + buffer + "\"");
    }

    public static Transport of(String buffer) throws IllegalArgumentException {
        if (buffer == null || buffer.isEmpty()) {
            throw new IllegalArgumentException("Illegal Transport - the transport buffer cannot be null or empty");
        }
        return Transport.of(Buffers.wrap((String)buffer));
    }

    public Buffer toBuffer() {
        return this.buffer;
    }

    public Buffer toUpperCaseBuffer() {
        return this.upperCaseBuffer;
    }
}

