/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.address;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.address.impl.TelURIImpl;
import io.pkts.packet.sip.header.impl.ParametersSupport;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import io.pkts.packet.sip.impl.TelUriParser;
import java.io.IOException;

public interface TelURI
extends URI {
    public boolean isGlobal();

    public Buffer getPhoneNumber();

    @Override
    default public boolean isTelURI() {
        return true;
    }

    @Override
    default public TelURI toTelURI() {
        return this;
    }

    public Buffer getParameter(Buffer var1) throws SipParseException, IllegalArgumentException;

    public Buffer getParameter(String var1) throws SipParseException, IllegalArgumentException;

    public static TelURI frame(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        Buffer original = buffer.slice();
        try {
            SipParser.expectTel(buffer);
        }
        catch (SipParseException e) {
            throw new SipParseException(e.getErrorOffset() - 1, "TEL URI must start with tel:");
        }
        TelUriParser parser = new TelUriParser(buffer, original);
        return parser.getTelUri();
    }

    public static Builder withPhoneNumber(Buffer phoneNumber) {
        Builder builder = new Builder();
        return builder.withPhoneNumber(phoneNumber);
    }

    public static Builder withPhoneNumber(String phoneNumber) {
        Builder builder = new Builder();
        return builder.withPhoneNumber(phoneNumber);
    }

    public static class Builder
    extends URI.Builder<TelURI> {
        private boolean isGlobal;
        private Buffer phoneNumber;
        private ParametersSupport paramSupport = new ParametersSupport();

        public Builder withPhoneNumber(Buffer phoneNumber) {
            PreConditions.assertNotNull(phoneNumber, "phoneNumber cannot be null");
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder withPhoneNumber(String phoneNumber) {
            PreConditions.assertNotEmpty(phoneNumber, "phoneNumber cannot be null or the empty string");
            return this.withPhoneNumber(Buffers.wrap((String)phoneNumber));
        }

        public Builder withGlobal(boolean isGlobal) {
            this.isGlobal = isGlobal;
            return this;
        }

        public Builder withParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, value);
            return this;
        }

        public Builder withParameter(String name, String value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, value);
            return this;
        }

        public Builder withParameter(String name, int value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(Buffers.wrap((String)name), Buffers.wrap((int)value));
            return this;
        }

        public Builder withParameter(Buffer name, int value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, Buffers.wrap((int)value));
            return this;
        }

        public Builder withNoParameters() {
            this.paramSupport = new ParametersSupport(null);
            return this;
        }

        public Builder withParameters(ParametersSupport paramSupport) {
            this.paramSupport = paramSupport;
            return this;
        }

        @Override
        public TelURI build() throws SipParseException {
            PreConditions.assertNotEmpty(this.phoneNumber, "Phone number cannot be empty");
            int size = 4;
            size += this.isGlobal ? 1 : 0;
            size += this.phoneNumber.capacity();
            Buffer params = this.paramSupport.toBuffer();
            if (params != null) {
                size += params.capacity();
            }
            Buffer uri = Buffers.createBuffer((int)size);
            SipParser.SCHEME_TEL_COLON.getBytes(0, uri);
            if (this.isGlobal) {
                uri.write((byte)43);
            }
            this.phoneNumber.getBytes(0, uri);
            params.getBytes(0, uri);
            return new TelURIImpl(this.isGlobal, this.phoneNumber, params, uri);
        }
    }
}

