/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.ExpiresHeaderImpl;
import io.pkts.packet.sip.impl.PreConditions;
import java.io.IOException;

public interface ExpiresHeader
extends SipHeader {
    public static final Buffer NAME = Buffers.wrap((String)"Expires");

    public int getExpires();

    @Override
    public ExpiresHeader clone();

    public static ExpiresHeader create(int expires) {
        PreConditions.assertArgument(expires >= 0, "The value must be greater or equal to zero");
        return new ExpiresHeaderImpl(expires);
    }

    public static ExpiresHeader frame(Buffer buffer) throws SipParseException {
        try {
            int value = buffer.parseToInt();
            return new ExpiresHeaderImpl(value);
        }
        catch (NumberFormatException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to parse the Expires header. Value is not an integer");
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to parse the Expires header. Got an IOException", e);
        }
    }

    @Override
    public Builder copy();

    @Override
    default public boolean isExpiresHeader() {
        return true;
    }

    @Override
    default public ExpiresHeader toExpiresHeader() {
        return this;
    }

    public static class Builder
    implements SipHeader.Builder<ExpiresHeader> {
        private int value;

        public Builder() {
            this(600);
        }

        public Builder(int value) {
            this.value = value;
        }

        public Builder withValue(int value) {
            this.value = value;
            return this;
        }

        public Builder withValue(Buffer value) {
            throw new RuntimeException("Not implemented yet");
        }

        @Override
        public ExpiresHeader build() throws SipParseException {
            PreConditions.assertArgument(this.value >= 0, "The value must be greater or equal to zero");
            return new ExpiresHeaderImpl(this.value);
        }
    }
}

