/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.ParametersSupport;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;

public interface MediaTypeHeader
extends SipHeader {
    public Buffer getContentType();

    public Buffer getContentSubType();

    public boolean isSDP();

    public static Buffer[] frame(Buffer buffer) throws SipParseException {
        if (buffer == null) {
            throw new SipParseException(0, "Cannot parse a null-buffer. Cmon!");
        }
        Buffer mType = SipParser.consumeMType(buffer);
        if (mType == null) {
            throw new SipParseException(buffer.getReaderIndex(), "Expected m-type but got nothing");
        }
        SipParser.expectSLASH(buffer);
        Buffer subType = SipParser.consumeMSubtype(buffer);
        if (subType == null) {
            throw new SipParseException(buffer.getReaderIndex(), "Expected m-subtype but got nothing");
        }
        return new Buffer[]{mType, subType};
    }

    public static abstract class Builder<T extends MediaTypeHeader>
    implements SipHeader.Builder<T> {
        private final Buffer name;
        private ParametersSupport paramSupport;
        private Buffer type;
        private Buffer subType;

        protected Builder(Buffer name) {
            this(name, null);
        }

        protected Builder(Buffer name, Buffer params) {
            this.name = name;
            this.paramSupport = new ParametersSupport(params);
        }

        public Builder<T> withParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, value);
            return this;
        }

        public Builder<T> withParameter(String name, String value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, value);
            return this;
        }

        public Builder<T> withParameters(Buffer params) {
            this.paramSupport = new ParametersSupport(params);
            return this;
        }

        public Builder<T> withNoParameters() {
            this.paramSupport = new ParametersSupport();
            return this;
        }

        public final Builder<T> withType(Buffer type) {
            this.type = type;
            return this;
        }

        public final Builder<T> withType(String type) {
            return this.withType(Buffers.wrap((String)type));
        }

        public final Builder<T> withSubType(Buffer subType) {
            this.subType = subType;
            return this;
        }

        public final Builder<T> withSubType(String subType) {
            return this.withSubType(Buffers.wrap((String)subType));
        }

        @Override
        public final T build() throws SipParseException {
            PreConditions.assertNotEmpty(this.type, "The content type cannot be null or empty");
            PreConditions.assertNotEmpty(this.subType, "The content sub-type cannot be null or empty");
            Buffer params = this.paramSupport.toBuffer();
            int size = this.type.capacity() + 1 + this.subType.capacity() + params.capacity();
            Buffer value = Buffers.createBuffer((int)size);
            this.type.getBytes(0, value);
            value.write((byte)47);
            this.subType.getBytes(0, value);
            params.getBytes(0, value);
            return this.internalBuild(value, this.type, this.subType, params);
        }

        protected abstract T internalBuild(Buffer var1, Buffer var2, Buffer var3, Buffer var4);
    }
}

