/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.utils.markers;

import java.io.File;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugins.dependency.utils.StringUtils;
import org.apache.maven.plugins.dependency.utils.markers.DefaultFileMarkerHandler;

public class UnpackFileMarkerHandler
extends DefaultFileMarkerHandler {
    protected ArtifactItem artifactItem;

    public UnpackFileMarkerHandler(File markerFilesDirectory) {
        super(markerFilesDirectory);
    }

    public UnpackFileMarkerHandler(ArtifactItem artifactItem, File markerFilesDirectory) {
        this(markerFilesDirectory);
        this.setArtifactItem(artifactItem);
    }

    @Override
    protected File getMarkerFile() {
        File markerFile;
        if (this.artifactItem == null || StringUtils.isEmpty(this.artifactItem.getIncludes()) && StringUtils.isEmpty(this.artifactItem.getExcludes())) {
            markerFile = super.getMarkerFile();
        } else {
            int includeExcludeHash = 0;
            if (StringUtils.isNotEmpty(this.artifactItem.getIncludes())) {
                includeExcludeHash += this.artifactItem.getIncludes().hashCode();
            }
            if (StringUtils.isNotEmpty(this.artifactItem.getExcludes())) {
                includeExcludeHash += this.artifactItem.getExcludes().hashCode();
            }
            markerFile = new File(this.markerFilesDirectory, this.artifact.getId().replace(':', '-') + includeExcludeHash);
        }
        return markerFile;
    }

    public void setArtifactItem(ArtifactItem artifactItem) {
        this.artifactItem = artifactItem;
        if (this.artifactItem != null) {
            this.setArtifact(this.artifactItem.getArtifact());
        }
    }

    public ArtifactItem getArtifactItem() {
        return this.artifactItem;
    }
}

