/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.libg.generics.Create;
import aQute.libg.qtokens.QuotedTokenizer;
import aQute.service.reporter.Reporter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintPlugin
implements AnalyzerPlugin {
    static Pattern QN = Pattern.compile("[_A-Za-z$][_A-Za-z0-9$]*(\\.[_A-Za-z$][_A-Za-z0-9$]*)*");
    static Pattern PATHS = Pattern.compile(".*\\.xml");
    Transformer transformer = this.getTransformer(this.getClass().getResource("blueprint.xsl"));

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        this.transformer.setParameter("nsh_interface", analyzer.getProperty("nsh_interface") != null ? analyzer.getProperty("nsh_interface") : "");
        this.transformer.setParameter("nsh_namespace", analyzer.getProperty("nsh_namespace") != null ? analyzer.getProperty("nsh_namespace") : "");
        Set headers = Create.set();
        String bpHeader = analyzer.getProperty("Bundle-Blueprint", "OSGI-INF/blueprint");
        Parameters map = Processor.parseHeader((String)bpHeader, null);
        bpHeader = "";
        for (String root : map.keySet()) {
            Jar jar = analyzer.getJar();
            Map dir = (Map)jar.getDirectories().get(root);
            if (dir == null || dir.isEmpty()) {
                Resource resource = jar.getResource(root);
                if (resource == null) continue;
                this.process(analyzer, root, resource, headers);
                if (bpHeader.length() > 0) {
                    bpHeader = bpHeader + ",";
                }
                bpHeader = bpHeader + root;
                continue;
            }
            for (Map.Entry entry : dir.entrySet()) {
                String path = (String)entry.getKey();
                Resource resource = (Resource)entry.getValue();
                if (!PATHS.matcher(path).matches()) continue;
                this.process(analyzer, path, resource, headers);
                if (bpHeader.length() > 0) {
                    bpHeader = bpHeader + ",";
                }
                bpHeader = bpHeader + path;
            }
        }
        if (!map.isEmpty()) {
            analyzer.setProperty("Bundle-Blueprint", bpHeader);
        }
        Map hdrs = Create.map();
        for (String str : headers) {
            int idx = str.indexOf(58);
            if (idx < 0) {
                analyzer.warning("Error analyzing services in blueprint resource: " + str, new Object[0]);
                continue;
            }
            String h = str.substring(0, idx).trim();
            String v = str.substring(idx + 1).trim();
            TreeSet<Attribute> att = (TreeSet<Attribute>)hdrs.get(h);
            if (att == null) {
                att = new TreeSet<Attribute>();
                hdrs.put(h, att);
            }
            att.addAll(BlueprintPlugin.parseHeader(v, null));
        }
        for (String header : hdrs.keySet()) {
            if ("Import-Class".equals(header) || "Import-Package".equals(header)) {
                Set newAttr = (Set)hdrs.get(header);
                for (Attribute a : newAttr) {
                    String pkg = a.getName();
                    if ("Import-Class".equals(header)) {
                        int n = a.getName().lastIndexOf(46);
                        if (n <= 0) continue;
                        pkg = ((Object)pkg.subSequence(0, n)).toString();
                    }
                    Descriptors.PackageRef pkgRef = analyzer.getPackageRef(pkg);
                    if (analyzer.getReferred().containsKey(pkgRef)) continue;
                    analyzer.getReferred().put(pkgRef).putAll(a.getProperties());
                }
                continue;
            }
            Set<Attribute> orgAttr = BlueprintPlugin.parseHeader(analyzer.getProperty(header), null);
            Set newAttr = (Set)hdrs.get(header);
            Iterator it = newAttr.iterator();
            block5: while (it.hasNext()) {
                Attribute a = (Attribute)it.next();
                for (Attribute b : orgAttr) {
                    if (!b.getName().equals(a.getName())) continue;
                    it.remove();
                    continue block5;
                }
            }
            orgAttr.addAll(newAttr);
            StringBuilder sb = new StringBuilder();
            for (Attribute a : orgAttr) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(a.getName());
                for (Map.Entry<String, String> prop : a.getProperties().entrySet()) {
                    sb.append(';').append(prop.getKey()).append("=");
                    if (prop.getValue().matches("[0-9a-zA-Z_-]+")) {
                        sb.append(prop.getValue());
                        continue;
                    }
                    sb.append("\"");
                    sb.append(prop.getValue().replace("\"", "\\\""));
                    sb.append("\"");
                }
            }
            analyzer.setProperty(header, sb.toString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Analyzer analyzer, String path, Resource resource, Set<String> headers) {
        InputStream in = null;
        try {
            in = resource.openInputStream();
            Set<String> set = this.analyze(in);
            headers.addAll(set);
        }
        catch (Exception e) {
            analyzer.error("Unexpected exception in processing spring resources(" + path + "): " + e, new Object[0]);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public Set<String> analyze(InputStream in) throws Exception {
        HashSet<String> refers = new HashSet<String>();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamResult r = new StreamResult(bout);
        StreamSource s = new StreamSource(in);
        this.transformer.transform(s, r);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        bout.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(bin));
        String line = br.readLine();
        while (line != null) {
            line = line.trim();
            if ((line = line.replace(";availability:=mandatory", "")).length() > 0) {
                refers.add(line);
            }
            line = br.readLine();
        }
        br.close();
        return refers;
    }

    protected Transformer getTransformer(URL url) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        StreamSource source = new StreamSource(url.openStream());
        return tf.newTransformer(source);
    }

    public static Set<Attribute> parseHeader(String value, Reporter logger) {
        if (value == null || value.trim().length() == 0) {
            return new TreeSet<Attribute>();
        }
        TreeSet<Attribute> result = new TreeSet<Attribute>();
        QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
        char del = '\u0000';
        do {
            boolean hadAttribute = false;
            Map clause = Create.map();
            List aliases = Create.list();
            String name = qt.nextToken(",;");
            del = qt.getSeparator();
            if (name == null || name.length() == 0) {
                if (logger != null && logger.isPedantic()) {
                    logger.warning("Empty clause, usually caused by repeating a comma without any name field or by having spaces after the backslash of a property file: " + value, new Object[0]);
                }
                if (name == null) break;
                continue;
            }
            name = name.trim();
            aliases.add(name);
            while (del == ';') {
                String adname = qt.nextToken();
                del = qt.getSeparator();
                if (del != '=') {
                    if (hadAttribute && logger != null) {
                        logger.error("Header contains name field after attribute or directive: " + adname + " from " + value + ". Name fields must be consecutive, separated by a ';' like a;b;c;x=3;y=4", new Object[0]);
                    }
                    if (adname == null || adname.length() <= 0) continue;
                    aliases.add(adname.trim());
                    continue;
                }
                String advalue = qt.nextToken();
                if (clause.containsKey(adname) && logger != null && logger.isPedantic()) {
                    logger.warning("Duplicate attribute/directive name " + adname + " in " + value + ". This attribute/directive will be ignored", new Object[0]);
                }
                if (advalue == null) {
                    if (logger != null) {
                        logger.error("No value after '=' sign for attribute " + adname, new Object[0]);
                    }
                    advalue = "";
                }
                clause.put(adname.trim(), advalue.trim());
                del = qt.getSeparator();
                hadAttribute = true;
            }
            for (String clauseName : aliases) {
                result.add(new Attribute(clauseName, clause));
            }
        } while (del == ',');
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Attribute
    implements Comparable<Attribute> {
        private final String name;
        private final Map<String, String> properties;

        public Attribute(String name, Map<String, String> properties) {
            this.name = name;
            this.properties = properties;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        @Override
        public int compareTo(Attribute a) {
            int c = this.name.compareTo(a.name);
            if (c == 0) {
                c = ((Object)this.properties).equals(a.properties) ? 0 : (this.properties.size() < a.properties.size() ? -1 : (((Object)this.properties).hashCode() < ((Object)a.properties).hashCode() ? -1 : 1));
            }
            return c;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute attribute = (Attribute)o;
            if (this.name != null ? !this.name.equals(attribute.name) : attribute.name != null) {
                return false;
            }
            return !(this.properties != null ? !((Object)this.properties).equals(attribute.properties) : attribute.properties != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.properties != null ? ((Object)this.properties).hashCode() : 0);
            return result;
        }
    }
}

