/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.fields;

import gov.nist.core.NameValue;
import gov.nist.javax.sdp.fields.SDPField;
import javax.sdp.Attribute;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;

public class AttributeField
extends SDPField
implements Attribute {
    protected NameValue attribute;

    public NameValue getAttribute() {
        return this.attribute;
    }

    public AttributeField() {
        super("a=");
    }

    public void setAttribute(NameValue a) {
        this.attribute = a;
        this.attribute.setSeparator(":");
    }

    @Override
    public String encode() {
        String encoded_string = "a=";
        if (this.attribute != null) {
            encoded_string = encoded_string + this.attribute.encode();
        }
        return encoded_string + "\r\n";
    }

    @Override
    public String toString() {
        return this.encode();
    }

    public String getName() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return null;
        }
        String name = nameValue.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    public void setName(String name) throws SdpException {
        if (name == null) {
            throw new SdpException("The name is null");
        }
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setName(name);
        this.setAttribute(nameValue);
    }

    public boolean hasValue() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return false;
        }
        Object value = nameValue.getValueAsObject();
        return value != null;
    }

    public String getValue() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return null;
        }
        Object value = nameValue.getValueAsObject();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public void setValue(String value) throws SdpException {
        if (value == null) {
            throw new SdpException("The value is null");
        }
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setValueAsObject(value);
        this.setAttribute(nameValue);
    }

    public void setValueAllowNull(String value) {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setValueAsObject(value);
        this.setAttribute(nameValue);
    }

    @Override
    public Object clone() {
        AttributeField retval = (AttributeField)super.clone();
        if (this.attribute != null) {
            retval.attribute = (NameValue)this.attribute.clone();
        }
        return retval;
    }

    @Override
    public boolean equals(Object that) {
        if (!(that instanceof AttributeField)) {
            return false;
        }
        AttributeField other = (AttributeField)that;
        return other.getAttribute().getName().equalsIgnoreCase(this.getAttribute().getName()) && this.getAttribute().getValueAsObject().equals(other.getAttribute().getValueAsObject());
    }

    public int hashCode() {
        if (this.getAttribute() == null) {
            throw new UnsupportedOperationException("Attribute is null cannot compute hashCode ");
        }
        return this.encode().hashCode();
    }
}

