/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.filters;

import io.pkts.filters.Filter;
import io.pkts.filters.FilterParseException;
import io.pkts.filters.SipCallIdFilter;
import io.pkts.filters.SipHeaderFilter;

public final class FilterFactory {
    private static final FilterFactory instance = new FilterFactory();

    public static final FilterFactory getInstance() {
        return instance;
    }

    private FilterFactory() {
    }

    public Filter createFilter(String expression) throws FilterParseException {
        String expr = expression.toLowerCase();
        if (!expr.startsWith("sip.")) {
            throw new FilterParseException(0, "Not a valid sip expression");
        }
        int index = expression.indexOf("==");
        if (index == -1) {
            throw new FilterParseException(expression.length(), "Expected a value. Missing '=='");
        }
        String token = expression.substring(0, index).trim();
        String value = expression.substring(index + 2, expression.length()).trim();
        if (token.equalsIgnoreCase("sip.call-id")) {
            return new SipCallIdFilter(value);
        }
        String[] parts = token.split("\\.");
        if (parts.length == 1) {
            throw new FilterParseException(0, "Expected \"sip.\"<value> but didn't find a dot");
        }
        if (parts.length > 2) {
            throw new FilterParseException(0, "Expected \"sip.\"<value> but found multiple dots so now I'm not sure what to do");
        }
        String headername = parts[1];
        return new SipHeaderFilter(headername, value);
    }
}

