/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.framer;

import io.pkts.buffer.Buffer;
import io.pkts.framer.Framer;
import io.pkts.packet.IPv4Packet;
import io.pkts.packet.Packet;
import io.pkts.packet.impl.IPv4PacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;

public class IPv4Framer
implements Framer<Packet, IPv4Packet> {
    @Override
    public Protocol getProtocol() {
        return Protocol.IPv4;
    }

    @Override
    public IPv4Packet frame(Packet parent, Buffer payload) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("The parent frame cannot be null");
        }
        Buffer headers = payload.readBytes(20);
        byte b = headers.getByte(0);
        int version = b >>> 5 & 0xF;
        int headerLength = b & 0xF;
        byte tos = headers.getByte(1);
        int totalLength = headers.getUnsignedShort(2);
        int options = 0;
        if (headerLength > 5) {
            options = payload.readInt();
        }
        int tcpLength = payload.getReaderIndex() + totalLength - headerLength * 4;
        Buffer data = payload.slice(Math.min(tcpLength, payload.capacity()));
        return new IPv4PacketImpl(parent, headers, options, data);
    }

    @Override
    public boolean accept(Buffer data) {
        return false;
    }
}

