/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.IPPacket;
import io.pkts.packet.Packet;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.impl.AbstractPacket;
import io.pkts.packet.impl.SDPPacketImpl;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipPacket;
import io.pkts.packet.sip.SipPacketParseException;
import io.pkts.packet.sip.SipRequestPacket;
import io.pkts.packet.sip.SipResponsePacket;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ContentTypeHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RecordRouteHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.protocol.Protocol;
import io.pkts.sdp.SDP;
import io.pkts.sdp.SDPFactory;
import io.pkts.sdp.SdpException;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class SipPacketImpl
extends AbstractPacket
implements SipPacket {
    private final SipMessage msg;

    public SipPacketImpl(TransportPacket parent, SipMessage msg) {
        super(Protocol.SIP, parent, null);
        this.msg = msg;
    }

    protected TransportPacket getTransportPacket() {
        return (TransportPacket)this.getParentPacket();
    }

    protected SipMessage getSipMessage() {
        return this.msg;
    }

    @Override
    public long getArrivalTime() {
        return this.getTransportPacket().getArrivalTime();
    }

    @Override
    public void write(OutputStream out, Buffer payload) throws IOException {
        this.getParentPacket().write(out, Buffers.wrap((Buffer)this.msg.toBuffer(), (Buffer)payload));
    }

    @Override
    public Buffer getInitialLine() {
        return this.msg.getInitialLine();
    }

    @Override
    public SipRequestPacket toRequest() throws ClassCastException {
        throw new ClassCastException("Unable to cast this SipMessage into a SipRequest");
    }

    @Override
    public SipResponsePacket toResponse() throws ClassCastException {
        throw new ClassCastException("Unable to cast this SipMessage into a SipResponse");
    }

    @Override
    public boolean isResponse() {
        return this.msg.isResponse();
    }

    @Override
    public boolean isRequest() {
        return this.msg.isRequest();
    }

    @Override
    public Object getContent() throws SipPacketParseException {
        return this.parseSipContent();
    }

    @Override
    public Buffer getRawContent() {
        return this.msg.getContent();
    }

    @Override
    public boolean hasContent() {
        return this.msg.hasContent();
    }

    @Override
    public Buffer getMethod() throws SipPacketParseException {
        return this.msg.getMethod();
    }

    @Override
    public List<SipHeader> getHeaders() {
        return this.msg.getAllHeaders();
    }

    @Override
    public Map<String, List<SipHeader>> getHeaderValues() {
        return this.msg.getHeaderValues();
    }

    @Override
    public Optional<SipHeader> getHeader(Buffer headerName) throws SipPacketParseException {
        return this.msg.getHeader(headerName);
    }

    @Override
    public Optional<SipHeader> getHeader(String headerName) throws SipPacketParseException {
        return this.msg.getHeader(headerName);
    }

    @Override
    public FromHeader getFromHeader() throws SipPacketParseException {
        return this.msg.getFromHeader();
    }

    @Override
    public ToHeader getToHeader() throws SipPacketParseException {
        return this.msg.getToHeader();
    }

    @Override
    public ViaHeader getViaHeader() throws SipPacketParseException {
        return this.msg.getViaHeader();
    }

    @Override
    public List<ViaHeader> getViaHeaders() throws SipPacketParseException {
        return this.msg.getViaHeaders();
    }

    @Override
    public MaxForwardsHeader getMaxForwards() throws SipPacketParseException {
        return this.msg.getMaxForwards();
    }

    @Override
    public RecordRouteHeader getRecordRouteHeader() throws SipPacketParseException {
        return this.msg.getRecordRouteHeader();
    }

    @Override
    public List<RecordRouteHeader> getRecordRouteHeaders() throws SipPacketParseException {
        return this.msg.getRecordRouteHeaders();
    }

    @Override
    public RouteHeader getRouteHeader() throws SipPacketParseException {
        return this.msg.getRouteHeader();
    }

    @Override
    public List<RouteHeader> getRouteHeaders() throws SipPacketParseException {
        return this.msg.getRouteHeaders();
    }

    @Override
    public ContactHeader getContactHeader() throws SipPacketParseException {
        return this.msg.getContactHeader();
    }

    @Override
    public ContentTypeHeader getContentTypeHeader() throws SipPacketParseException {
        return this.msg.getContentTypeHeader();
    }

    @Override
    public CallIdHeader getCallIDHeader() throws SipPacketParseException {
        return this.msg.getCallIDHeader();
    }

    @Override
    public CSeqHeader getCSeqHeader() throws SipPacketParseException {
        return this.msg.getCSeqHeader();
    }

    @Override
    public boolean isInvite() throws SipPacketParseException {
        return this.msg.isInvite();
    }

    @Override
    public boolean isBye() throws SipPacketParseException {
        return this.msg.isBye();
    }

    @Override
    public boolean isAck() throws SipPacketParseException {
        return this.msg.isAck();
    }

    @Override
    public boolean isOptions() throws SipPacketParseException {
        return this.msg.isOptions();
    }

    @Override
    public boolean isMessage() throws SipPacketParseException {
        return this.msg.isMessage();
    }

    @Override
    public boolean isInfo() throws SipPacketParseException {
        return this.msg.isInfo();
    }

    @Override
    public boolean isCancel() throws SipPacketParseException {
        return this.msg.isCancel();
    }

    @Override
    public boolean isInitial() throws SipPacketParseException {
        return this.msg.isInitial();
    }

    @Override
    public void verify() {
        this.msg.verify();
    }

    @Override
    public Buffer toBuffer() {
        return this.msg.toBuffer();
    }

    @Override
    public abstract SipPacket clone();

    private Object parseSipContent() {
        try {
            Buffer content = this.msg.getContent();
            ContentTypeHeader contentType = this.getContentTypeHeader();
            if (content != null && !content.isEmpty() && contentType.isSDP()) {
                return SDPFactory.getInstance().parse(content);
            }
        }
        catch (SipPacketParseException | SdpException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Packet getNextPacket() throws IOException {
        Object content = this.parseSipContent();
        if (content instanceof SDP) {
            return new SDPPacketImpl(this, (SDP)content);
        }
        return null;
    }

    @Override
    public Buffer getPayload() {
        return this.msg.getContent();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getTransportPacket().isUDP()) {
            sb.append("U ");
        } else if (this.getTransportPacket().isTCP()) {
            sb.append("T ");
        }
        Instant timestamp = Instant.ofEpochMilli(this.getArrivalTime() / 1000L);
        IPPacket ipPacket = (IPPacket)this.getParentPacket().getParentPacket();
        sb.append(timestamp.toString()).append(" ").append(ipPacket.getSourceIP()).append(":").append(this.getTransportPacket().getSourcePort()).append(" -> ").append(ipPacket.getDestinationIP()).append(":").append(this.getTransportPacket().getDestinationPort()).append("\n").append(this.msg.toString());
        return sb.toString();
    }
}

