/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.util.Fields;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AbstractAttributedCharacterIteratorAttributeConverter
extends AbstractSingleValueConverter {
    private static final Map instanceMaps = new HashMap();
    private static final Method getName;
    private final Class type;
    private transient Map attributeMap;

    public AbstractAttributedCharacterIteratorAttributeConverter(Class type) {
        if (!AttributedCharacterIterator.Attribute.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(type.getName() + " is not a " + AttributedCharacterIterator.Attribute.class.getName());
        }
        this.type = type;
        this.readResolve();
    }

    public boolean canConvert(Class type) {
        return type == this.type;
    }

    public String toString(Object source) {
        return this.getName((AttributedCharacterIterator.Attribute)source);
    }

    private String getName(AttributedCharacterIterator.Attribute attribute) {
        String className;
        String s;
        ReflectiveOperationException ex = null;
        if (getName != null) {
            try {
                return (String)getName.invoke((Object)attribute, (Object[])null);
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (InvocationTargetException e) {
                ex = e;
            }
        }
        if ((s = attribute.toString()).startsWith(className = attribute.getClass().getName())) {
            return s.substring(className.length() + 1, s.length() - 1);
        }
        throw new ConversionException("Cannot find name of attribute of type " + className, ex);
    }

    public Object fromString(String str) {
        if (this.attributeMap.containsKey(str)) {
            return this.attributeMap.get(str);
        }
        throw new ConversionException("Cannot find attribute of type " + this.type.getName() + " with name " + str);
    }

    private Object readResolve() {
        this.attributeMap = (Map)instanceMaps.get(this.type.getName());
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap();
            Field instanceMap = Fields.locate(this.type, Map.class, true);
            if (instanceMap != null) {
                try {
                    Map map = (Map)Fields.read(instanceMap, null);
                    if (map != null) {
                        boolean valid = true;
                        Iterator iter = map.entrySet().iterator();
                        while (valid && iter.hasNext()) {
                            Map.Entry entry = iter.next();
                            valid = entry.getKey().getClass() == String.class && entry.getValue().getClass() == this.type;
                        }
                        if (valid) {
                            this.attributeMap.putAll(map);
                        }
                    }
                }
                catch (ObjectAccessException e) {
                    // empty catch block
                }
            }
            if (this.attributeMap.isEmpty()) {
                try {
                    Field[] fields = this.type.getDeclaredFields();
                    for (int i = 0; i < fields.length; ++i) {
                        if (fields[i].getType() == this.type != Modifier.isStatic(fields[i].getModifiers())) continue;
                        AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)Fields.read(fields[i], null);
                        this.attributeMap.put(this.toString(attribute), attribute);
                    }
                }
                catch (SecurityException e) {
                    this.attributeMap.clear();
                }
                catch (ObjectAccessException e) {
                    this.attributeMap.clear();
                }
            }
        }
        return this;
    }

    static {
        Method method = null;
        try {
            method = AttributedCharacterIterator.Attribute.class.getDeclaredMethod("getName", null);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        getName = method;
    }
}

