/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import org.apache.commons.beanutils.BeanUtils;
import org.sonatype.nexus.client.core.spi.SubsystemSupport;
import org.sonatype.nexus.client.core.subsystem.repository.Repository;
import org.sonatype.nexus.client.core.subsystem.repository.RepositoryStatus;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.RepositoryStatusImpl;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryStatusResource;
import org.sonatype.nexus.rest.model.RepositoryStatusResourceResponse;

public abstract class JerseyRepository<T extends Repository, S extends RepositoryBaseResource, U extends RepositoryStatus>
extends SubsystemSupport<JerseyNexusClient>
implements Repository<T, U> {
    private final String id;
    private final S settings;
    private RepositoryStatusResource status;
    private boolean shouldCreate;

    public JerseyRepository(JerseyNexusClient nexusClient, String id) {
        super(nexusClient);
        this.id = id;
        this.settings = (RepositoryBaseResource)Preconditions.checkNotNull(this.createSettings());
        this.shouldCreate = true;
        this.status = null;
        this.settings().setId(this.id);
    }

    public JerseyRepository(JerseyNexusClient nexusClient, S settings) {
        this(nexusClient, (String)Preconditions.checkNotNull((Object)((RepositoryBaseResource)Preconditions.checkNotNull(settings)).getId()));
        this.shouldCreate = false;
        super.overwriteSettingsWith((String)settings);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.settings().getName();
    }

    @Override
    public String contentUri() {
        return this.settings().getContentResourceURI();
    }

    @Override
    public T withName(String name) {
        this.settings().setName(name);
        return this.me();
    }

    protected S settings() {
        return this.settings;
    }

    @Override
    public synchronized T refresh() {
        S processed = null;
        if (!this.shouldCreate) {
            processed = this.doGet();
        }
        this.shouldCreate = processed == null;
        this.status = null;
        this.overwriteSettingsWith(processed);
        return this.me();
    }

    @Override
    public synchronized T save() {
        S processed = this.shouldCreate ? this.doCreate() : this.doUpdate();
        this.overwriteSettingsWith(processed);
        this.shouldCreate = false;
        this.status = null;
        return this.me();
    }

    @Override
    public synchronized T remove() {
        this.doRemove();
        this.shouldCreate = true;
        this.status = null;
        return this.me();
    }

    @Override
    public U status() {
        if (this.status == null && !this.shouldCreate) {
            this.status = this.doGetStatus();
        }
        return this.convertStatus(this.status);
    }

    @Override
    public T putInService() {
        RepositoryStatusResource newStatus = this.doGetStatus();
        newStatus.setLocalStatus("IN_SERVICE");
        this.doUpdateStatus(newStatus);
        return this.me();
    }

    @Override
    public T putOutOfService() {
        RepositoryStatusResource newStatus = this.doGetStatus();
        newStatus.setLocalStatus("OUT_OF_SERVICE");
        this.doUpdateStatus(newStatus);
        return this.me();
    }

    protected abstract S createSettings();

    String uri() {
        return "repositories";
    }

    private void overwriteSettingsWith(S source) {
        try {
            BeanUtils.copyProperties(this.settings(), source == null ? (RepositoryBaseResource)Preconditions.checkNotNull(this.createSettings()) : source);
            this.settings().setId(this.id());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private T me() {
        return (T)this;
    }

    S doGet() {
        try {
            return (S)((RepositoryResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(this.uri() + "/" + this.id()).get(RepositoryResourceResponse.class)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    S doCreate() {
        RepositoryResourceResponse request = new RepositoryResourceResponse();
        request.setData(this.settings());
        try {
            return (S)((RepositoryResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(this.uri()).post(RepositoryResourceResponse.class, (Object)request)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    S doUpdate() {
        RepositoryResourceResponse request = new RepositoryResourceResponse();
        request.setData(this.settings());
        try {
            return (S)((RepositoryResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(this.uri() + "/" + this.id()).put(RepositoryResourceResponse.class, (Object)request)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    private void doRemove() {
        try {
            ((JerseyNexusClient)this.getNexusClient()).serviceResource(this.uri() + "/" + this.id()).delete();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    U convertStatus(RepositoryStatusResource status) {
        if (status == null) {
            return (U)new RepositoryStatusImpl(false);
        }
        return (U)new RepositoryStatusImpl("IN_SERVICE".equals(status.getLocalStatus()));
    }

    RepositoryStatusResource doGetStatus() {
        try {
            return ((RepositoryStatusResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource("repositories/" + this.id() + "/status").get(RepositoryStatusResourceResponse.class)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    RepositoryStatusResource doUpdateStatus(RepositoryStatusResource status) {
        RepositoryStatusResourceResponse request = new RepositoryStatusResourceResponse();
        request.setData(status);
        try {
            this.status = ((RepositoryStatusResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource("repositories/" + this.id() + "/status").put(RepositoryStatusResourceResponse.class, (Object)request)).getData();
            return this.status;
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public boolean isExposed() {
        return this.settings().isExposed();
    }
}

