/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.hawtbuf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.sonatype.spice.zapper.internal.hawtbuf.SegmentHeaderBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SegmentHeader
extends SegmentHeaderBase<SegmentHeader> {
    public ArrayList<String> missingFields() {
        ArrayList missingFields = super.missingFields();
        if (!this.hasMagic()) {
            missingFields.add("magic");
        }
        if (!this.hasFileId()) {
            missingFields.add("fileId");
        }
        if (!this.hasSegmentId()) {
            missingFields.add("segmentId");
        }
        if (!this.hasSegmentOffset()) {
            missingFields.add("segmentOffset");
        }
        if (!this.hasSegmentLength()) {
            missingFields.add("segmentLength");
        }
        return missingFields;
    }

    public void clear() {
        super.clear();
        this.clearMagic();
        this.clearFileId();
        this.clearSegmentId();
        this.clearSegmentOffset();
        this.clearSegmentLength();
        this.clearFilters();
    }

    public SegmentHeader clone() {
        return new SegmentHeader().mergeFrom(this);
    }

    public SegmentHeader mergeFrom(SegmentHeader other) {
        if (other.hasMagic()) {
            this.setMagic(other.getMagic());
        }
        if (other.hasFileId()) {
            this.setFileId(other.getFileId());
        }
        if (other.hasSegmentId()) {
            this.setSegmentId(other.getSegmentId());
        }
        if (other.hasSegmentOffset()) {
            this.setSegmentOffset(other.getSegmentOffset());
        }
        if (other.hasSegmentLength()) {
            this.setSegmentLength(other.getSegmentLength());
        }
        if (other.hasFilters()) {
            this.getFiltersList().addAll(other.getFiltersList());
        }
        return this;
    }

    public int serializedSizeUnframed() {
        if (this.memoizedSerializedSize != -1) {
            return this.memoizedSerializedSize;
        }
        int size = 0;
        if (this.hasMagic()) {
            size += CodedOutputStream.computeStringSize((int)1, (String)this.getMagic());
        }
        if (this.hasFileId()) {
            size += CodedOutputStream.computeStringSize((int)2, (String)this.getFileId());
        }
        if (this.hasSegmentId()) {
            size += CodedOutputStream.computeStringSize((int)3, (String)this.getSegmentId());
        }
        if (this.hasSegmentOffset()) {
            size += CodedOutputStream.computeInt64Size((int)4, (long)this.getSegmentOffset());
        }
        if (this.hasSegmentLength()) {
            size += CodedOutputStream.computeInt64Size((int)5, (long)this.getSegmentLength());
        }
        if (this.hasFilters()) {
            for (String i : this.getFiltersList()) {
                size += CodedOutputStream.computeStringSize((int)6, (String)i);
            }
        }
        this.memoizedSerializedSize = size;
        return size;
    }

    public SegmentHeader mergeUnframed(CodedInputStream input) throws IOException {
        int tag;
        block9: while (((tag = input.readTag()) & 7) != 4) {
            switch (tag) {
                case 0: {
                    return this;
                }
                default: {
                    continue block9;
                }
                case 10: {
                    this.setMagic(input.readString());
                    continue block9;
                }
                case 18: {
                    this.setFileId(input.readString());
                    continue block9;
                }
                case 26: {
                    this.setSegmentId(input.readString());
                    continue block9;
                }
                case 32: {
                    this.setSegmentOffset(input.readInt64());
                    continue block9;
                }
                case 40: {
                    this.setSegmentLength(input.readInt64());
                    continue block9;
                }
                case 50: 
            }
            this.getFiltersList().add(input.readString());
        }
        return this;
    }

    public void writeUnframed(CodedOutputStream output) throws IOException {
        if (this.hasMagic()) {
            output.writeString(1, this.getMagic());
        }
        if (this.hasFileId()) {
            output.writeString(2, this.getFileId());
        }
        if (this.hasSegmentId()) {
            output.writeString(3, this.getSegmentId());
        }
        if (this.hasSegmentOffset()) {
            output.writeInt64(4, this.getSegmentOffset());
        }
        if (this.hasSegmentLength()) {
            output.writeInt64(5, this.getSegmentLength());
        }
        if (this.hasFilters()) {
            for (String i : this.getFiltersList()) {
                output.writeString(6, i);
            }
        }
    }

    public static SegmentHeader parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (SegmentHeader)((Object)new SegmentHeader().mergeUnframed(data).checktInitialized());
    }

    public static SegmentHeader parseUnframed(Buffer data) throws InvalidProtocolBufferException {
        return (SegmentHeader)((Object)((SegmentHeader)((Object)new SegmentHeader().mergeUnframed(data))).checktInitialized());
    }

    public static SegmentHeader parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return (SegmentHeader)((Object)((SegmentHeader)((Object)new SegmentHeader().mergeUnframed(data))).checktInitialized());
    }

    public static SegmentHeader parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (SegmentHeader)((Object)((SegmentHeader)((Object)new SegmentHeader().mergeUnframed(data))).checktInitialized());
    }

    public static SegmentHeader parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (SegmentHeader)((Object)((SegmentHeader)((Object)new SegmentHeader().mergeFramed(data))).checktInitialized());
    }

    public static SegmentHeader parseFramed(Buffer data) throws InvalidProtocolBufferException {
        return (SegmentHeader)((Object)((SegmentHeader)((Object)new SegmentHeader().mergeFramed(data))).checktInitialized());
    }

    public static SegmentHeader parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return (SegmentHeader)((Object)((SegmentHeader)((Object)new SegmentHeader().mergeFramed(data))).checktInitialized());
    }

    public static SegmentHeader parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (SegmentHeader)((Object)((SegmentHeader)((Object)new SegmentHeader().mergeFramed(data))).checktInitialized());
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    public StringBuilder toString(StringBuilder sb, String prefix) {
        if (this.hasMagic()) {
            sb.append(prefix + "magic: ");
            sb.append(this.getMagic());
            sb.append("\n");
        }
        if (this.hasFileId()) {
            sb.append(prefix + "fileId: ");
            sb.append(this.getFileId());
            sb.append("\n");
        }
        if (this.hasSegmentId()) {
            sb.append(prefix + "segmentId: ");
            sb.append(this.getSegmentId());
            sb.append("\n");
        }
        if (this.hasSegmentOffset()) {
            sb.append(prefix + "segmentOffset: ");
            sb.append(this.getSegmentOffset());
            sb.append("\n");
        }
        if (this.hasSegmentLength()) {
            sb.append(prefix + "segmentLength: ");
            sb.append(this.getSegmentLength());
            sb.append("\n");
        }
        if (this.hasFilters()) {
            List l = this.getFiltersList();
            for (int i = 0; i < l.size(); ++i) {
                sb.append(prefix + "filters[" + i + "]: ");
                sb.append((String)l.get(i));
                sb.append("\n");
            }
        }
        return sb;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != SegmentHeader.class) {
            return false;
        }
        return this.equals((SegmentHeader)((Object)obj));
    }

    public boolean equals(SegmentHeader obj) {
        if (this.hasMagic() ^ obj.hasMagic()) {
            return false;
        }
        if (this.hasMagic() && !this.getMagic().equals(obj.getMagic())) {
            return false;
        }
        if (this.hasFileId() ^ obj.hasFileId()) {
            return false;
        }
        if (this.hasFileId() && !this.getFileId().equals(obj.getFileId())) {
            return false;
        }
        if (this.hasSegmentId() ^ obj.hasSegmentId()) {
            return false;
        }
        if (this.hasSegmentId() && !this.getSegmentId().equals(obj.getSegmentId())) {
            return false;
        }
        if (this.hasSegmentOffset() ^ obj.hasSegmentOffset()) {
            return false;
        }
        if (this.hasSegmentOffset() && this.getSegmentOffset() != obj.getSegmentOffset()) {
            return false;
        }
        if (this.hasSegmentLength() ^ obj.hasSegmentLength()) {
            return false;
        }
        if (this.hasSegmentLength() && this.getSegmentLength() != obj.getSegmentLength()) {
            return false;
        }
        if (this.hasFilters() ^ obj.hasFilters()) {
            return false;
        }
        return !this.hasFilters() || this.getFiltersList().equals(obj.getFiltersList());
    }

    public int hashCode() {
        int rc = -477615232;
        if (this.hasMagic()) {
            rc ^= 0x46AB98D ^ this.getMagic().hashCode();
        }
        if (this.hasFileId()) {
            rc ^= 0x7D6D7BD7 ^ this.getFileId().hashCode();
        }
        if (this.hasSegmentId()) {
            rc ^= 0x166BC78E ^ this.getSegmentId().hashCode();
        }
        if (this.hasSegmentOffset()) {
            rc ^= 0xEF8AAD86 ^ new Long(this.getSegmentOffset()).hashCode();
        }
        if (this.hasSegmentLength()) {
            rc ^= 0xEA6183D9 ^ new Long(this.getSegmentLength()).hashCode();
        }
        if (this.hasFilters()) {
            rc ^= 0x30493BDB ^ this.getFiltersList().hashCode();
        }
        return rc;
    }
}

