/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.hawtbuf;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtbuf.proto.BaseMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SegmentHeaderBase<T>
extends BaseMessage<T> {
    private String f_magic = "zSeh";
    private boolean b_magic;
    private String f_fileId = null;
    private boolean b_fileId;
    private String f_segmentId = null;
    private boolean b_segmentId;
    private long f_segmentOffset = 0L;
    private boolean b_segmentOffset;
    private long f_segmentLength = 0L;
    private boolean b_segmentLength;
    private List<String> f_filters;

    SegmentHeaderBase() {
    }

    public boolean hasMagic() {
        return this.b_magic;
    }

    public String getMagic() {
        return this.f_magic;
    }

    public T setMagic(String magic) {
        this.loadAndClear();
        this.b_magic = true;
        this.f_magic = magic;
        return (T)((Object)this);
    }

    public void clearMagic() {
        this.loadAndClear();
        this.b_magic = false;
        this.f_magic = "zSeh";
    }

    public boolean hasFileId() {
        return this.b_fileId;
    }

    public String getFileId() {
        return this.f_fileId;
    }

    public T setFileId(String fileId) {
        this.loadAndClear();
        this.b_fileId = true;
        this.f_fileId = fileId;
        return (T)((Object)this);
    }

    public void clearFileId() {
        this.loadAndClear();
        this.b_fileId = false;
        this.f_fileId = null;
    }

    public boolean hasSegmentId() {
        return this.b_segmentId;
    }

    public String getSegmentId() {
        return this.f_segmentId;
    }

    public T setSegmentId(String segmentId) {
        this.loadAndClear();
        this.b_segmentId = true;
        this.f_segmentId = segmentId;
        return (T)((Object)this);
    }

    public void clearSegmentId() {
        this.loadAndClear();
        this.b_segmentId = false;
        this.f_segmentId = null;
    }

    public boolean hasSegmentOffset() {
        return this.b_segmentOffset;
    }

    public long getSegmentOffset() {
        return this.f_segmentOffset;
    }

    public T setSegmentOffset(long segmentOffset) {
        this.loadAndClear();
        this.b_segmentOffset = true;
        this.f_segmentOffset = segmentOffset;
        return (T)((Object)this);
    }

    public void clearSegmentOffset() {
        this.loadAndClear();
        this.b_segmentOffset = false;
        this.f_segmentOffset = 0L;
    }

    public boolean hasSegmentLength() {
        return this.b_segmentLength;
    }

    public long getSegmentLength() {
        return this.f_segmentLength;
    }

    public T setSegmentLength(long segmentLength) {
        this.loadAndClear();
        this.b_segmentLength = true;
        this.f_segmentLength = segmentLength;
        return (T)((Object)this);
    }

    public void clearSegmentLength() {
        this.loadAndClear();
        this.b_segmentLength = false;
        this.f_segmentLength = 0L;
    }

    public boolean hasFilters() {
        return this.f_filters != null && !this.f_filters.isEmpty();
    }

    public List<String> getFiltersList() {
        if (this.f_filters == null) {
            this.f_filters = new ArrayList<String>();
        }
        return this.f_filters;
    }

    public T setFiltersList(List<String> filters) {
        this.loadAndClear();
        this.f_filters = filters;
        return (T)((Object)this);
    }

    public int getFiltersCount() {
        if (this.f_filters == null) {
            return 0;
        }
        return this.f_filters.size();
    }

    public String getFilters(int index) {
        if (this.f_filters == null) {
            return null;
        }
        return this.f_filters.get(index);
    }

    public T setFilters(int index, String value) {
        this.loadAndClear();
        this.getFiltersList().set(index, value);
        return (T)((Object)this);
    }

    public T addFilters(String value) {
        this.loadAndClear();
        this.getFiltersList().add(value);
        return (T)((Object)this);
    }

    public T addAllFilters(Iterable<? extends String> collection) {
        this.loadAndClear();
        BaseMessage.addAll(collection, this.getFiltersList());
        return (T)((Object)this);
    }

    public void clearFilters() {
        this.loadAndClear();
        this.f_filters = null;
    }
}

