/*
 * Decompiled with CFR 0.152.
 */
package com.github.gantsign.maven.plugin.ktlint.internal;

import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.rule.engine.api.Code;
import com.pinterest.ktlint.rule.engine.api.KtLintParseException;
import com.pinterest.ktlint.rule.engine.api.KtLintRuleException;
import java.util.Locale;
import java.util.ResourceBundle;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0080\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\n"}, d2={"get", "", "Ljava/util/ResourceBundle;", "key", "toKtlintCliError", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "code", "Lcom/pinterest/ktlint/rule/engine/api/Code;", "ktlint-maven-plugin"})
public final class FunctionsKt {
    @NotNull
    public static final String get(@NotNull ResourceBundle $this$get, @NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if ($this$get.containsKey(key)) {
            String string2 = $this$get.getString(key);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        } else {
            string = key;
        }
        return string;
    }

    @NotNull
    public static final KtlintCliError toKtlintCliError(@NotNull Exception $this$toKtlintCliError, @NotNull Code code) {
        KtlintCliError ktlintCliError;
        Intrinsics.checkNotNullParameter((Object)$this$toKtlintCliError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Exception e = $this$toKtlintCliError;
        boolean bl = false;
        Exception exception = e;
        if (exception instanceof KtLintParseException) {
            String string;
            int n = ((KtLintParseException)e).getLine();
            int n2 = ((KtLintParseException)e).getCol();
            StringBuilder stringBuilder = new StringBuilder().append("Not a valid Kotlin file (");
            String string2 = e.getMessage();
            if (string2 != null) {
                String string3 = string2;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string4 = string3.toLowerCase(locale);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            } else {
                string = null;
            }
            ktlintCliError = new KtlintCliError(n, n2, "", stringBuilder.append(string).append(')').toString(), KtlintCliError.Status.KOTLIN_PARSE_EXCEPTION);
        } else if (exception instanceof KtLintRuleException) {
            ktlintCliError = new KtlintCliError(((KtLintRuleException)e).getLine(), ((KtLintRuleException)e).getCol(), "", "Internal Error (rule '" + ((KtLintRuleException)e).getRuleId() + "') in " + code.fileNameOrStdin() + " at position '" + ((KtLintRuleException)e).getLine() + ':' + ((KtLintRuleException)e).getCol() + ". Please create a ticket at https://github.com/pinterest/ktlint/issues and provide the source code that triggered an error.\n" + ExceptionsKt.stackTraceToString((Throwable)e), KtlintCliError.Status.KTLINT_RULE_ENGINE_EXCEPTION);
        } else {
            throw e;
        }
        return ktlintCliError;
    }
}

