/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final Map<Class<?>, Class<?>> primitiveToWrapperType = new HashMap(8);
    public static final Method OBJECT_EQUALS;
    public static final Method OBJECT_HASHCODE;
    public static final Method OBJECT_TOSTRING;
    public static final Method OBJECT_FINALIZE;

    private ReflectionUtils() {
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectionUtils.findMethod(clazz, name, null);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods = searchType.getDeclaredMethods();
            Method result = null;
            for (Method method : methods) {
                if (Modifier.isPrivate(method.getModifiers()) || method.isBridge() || !name.equals(method.getName())) continue;
                if (paramTypes == null) {
                    if (result != null) {
                        throw new RuntimeException("Ambiguous name: More than one method are named " + name);
                    }
                    result = method;
                    continue;
                }
                if (!Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Object ... objs) throws NoSuchMethodException {
        Constructor<?> ret = null;
        for (Constructor<?> classConstructor : clazz.getDeclaredConstructors()) {
            if (!ReflectionUtils.isMatchingConstructor(classConstructor, objs)) continue;
            if (ret != null) {
                throw new IllegalArgumentException("Ambiguity in the constructors for " + clazz.getName() + ".");
            }
            ret = classConstructor;
        }
        if (ret != null) {
            return ret;
        }
        throw new NoSuchMethodException("Couldn't find constructor for class " + clazz.getName());
    }

    private static boolean isMatchingConstructor(Constructor<?> classConstructor, Object ... objs) {
        if (Modifier.isPrivate(classConstructor.getModifiers())) {
            return false;
        }
        Class<?>[] parameterTypes = classConstructor.getParameterTypes();
        if (parameterTypes.length != objs.length) {
            return false;
        }
        for (int i = 0; i < objs.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (parameterType.isPrimitive()) {
                parameterType = ReflectionUtils.wrapPrimitive(parameterType);
            }
            if (parameterType.isInstance(objs[i])) continue;
            return false;
        }
        return true;
    }

    private static Class<?> wrapPrimitive(Class<?> parameterType) {
        return primitiveToWrapperType.get(parameterType);
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        try {
            return clazz.getDeclaredMethod(name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        primitiveToWrapperType.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapperType.put(Byte.TYPE, Byte.class);
        primitiveToWrapperType.put(Short.TYPE, Short.class);
        primitiveToWrapperType.put(Character.TYPE, Character.class);
        primitiveToWrapperType.put(Integer.TYPE, Integer.class);
        primitiveToWrapperType.put(Long.TYPE, Long.class);
        primitiveToWrapperType.put(Float.TYPE, Float.class);
        primitiveToWrapperType.put(Double.TYPE, Double.class);
        OBJECT_EQUALS = ReflectionUtils.getDeclaredMethod(Object.class, "equals", Object.class);
        OBJECT_HASHCODE = ReflectionUtils.getDeclaredMethod(Object.class, "hashCode", null);
        OBJECT_TOSTRING = ReflectionUtils.getDeclaredMethod(Object.class, "toString", null);
        OBJECT_FINALIZE = ReflectionUtils.getDeclaredMethod(Object.class, "finalize", null);
    }
}

