/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.thumbnail;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.xmpp.extensions.thumbnail.Thumbnail;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jxmpp.util.XmppDateTime;

public class ThumbnailFile
extends StreamInitiation.File {
    public static final String ELEMENT = "file";
    public static final String NAMESPACE = "http://jabber.org/protocol/si/profile/file-transfer";
    private Thumbnail thumbnail;

    public ThumbnailFile(StreamInitiation.File baseFile, Thumbnail thumbnail) {
        this(baseFile.getName(), baseFile.getSize());
        this.thumbnail = thumbnail;
    }

    public ThumbnailFile(String name, long size) {
        super(name, size);
    }

    public String toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder();
        xml.halfOpenElement(this.getElementName());
        xml.xmlnsAttribute(this.getNamespace());
        if (this.getSize() > 0L) {
            xml.attribute("size", String.valueOf(this.getSize()));
        }
        if (this.getDate() != null) {
            xml.attribute("date", XmppDateTime.formatXEP0082Date((Date)this.getDate()));
        }
        xml.optAttribute("hash", this.getHash());
        xml.rightAngleBracket();
        String desc = this.getDesc();
        if (StringUtils.isNotEmpty((CharSequence)desc) || this.isRanged() || this.thumbnail != null) {
            if (StringUtils.isNotEmpty((CharSequence)desc)) {
                xml.element("desc", desc);
            }
            if (this.isRanged()) {
                xml.emptyElement("range");
            }
            if (this.thumbnail != null) {
                xml.append((CharSequence)this.thumbnail.toXML(enclosingNamespace));
            }
            xml.closeElement(this.getElementName());
        } else {
            xml.closeEmptyElement();
        }
        return xml.toString();
    }

    public Thumbnail getThumbnail() {
        return this.thumbnail;
    }

    void setThumbnail(Thumbnail thumbnail) {
        this.thumbnail = thumbnail;
    }
}

