/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.branch;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.branch.AbstractBranchCommand;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.branch.GitCurrentBranchConsumer;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListCommand;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitBranchCommand
extends AbstractBranchCommand
implements GitCommand {
    public ScmResult executeBranchCommand(ScmProviderRepository repo, ScmFileSet fileSet, String branch, String message) throws ScmException {
        Commandline clPush;
        CommandLineUtils.StringStreamConsumer stderr;
        CommandLineUtils.StringStreamConsumer stdout;
        if (branch == null || StringUtils.isEmpty((String)branch.trim())) {
            throw new ScmException("branch name must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support branching subsets of a directory");
        }
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        Commandline cl = GitBranchCommand.createCommandLine(repository, fileSet.getBasedir(), branch);
        int exitCode = GitCommandLineUtils.execute(cl, stdout = new CommandLineUtils.StringStreamConsumer(), stderr = new CommandLineUtils.StringStreamConsumer(), this.getLogger());
        if (exitCode != 0) {
            return new BranchScmResult(cl.toString(), "The git-branch command failed.", stderr.getOutput(), false);
        }
        if (repo.isPushChanges() && (exitCode = GitCommandLineUtils.execute(clPush = GitBranchCommand.createPushCommandLine(repository, fileSet, branch), stdout, stderr, this.getLogger())) != 0) {
            return new BranchScmResult(clPush.toString(), "The git-push command failed.", stderr.getOutput(), false);
        }
        GitListConsumer listConsumer = new GitListConsumer(this.getLogger(), fileSet.getBasedir(), ScmFileStatus.TAGGED);
        Commandline clList = GitListCommand.createCommandLine(repository, fileSet.getBasedir());
        exitCode = GitCommandLineUtils.execute(clList, listConsumer, stderr, this.getLogger());
        if (exitCode != 0) {
            return new BranchScmResult(clList.toString(), "The git-ls-files command failed.", stderr.getOutput(), false);
        }
        return new BranchScmResult(cl.toString(), listConsumer.getListedFiles());
    }

    public static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, String branch) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "branch");
        cl.createArg().setValue(branch);
        return cl;
    }

    public static Commandline createPushCommandLine(GitScmProviderRepository repository, ScmFileSet fileSet, String branch) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "push");
        cl.createArg().setValue(repository.getPushUrl());
        cl.createArg().setValue("refs/heads/" + branch);
        return cl;
    }

    public static String getCurrentBranch(ScmLogger logger, GitScmProviderRepository repository, ScmFileSet fileSet) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "symbolic-ref");
        cl.createArg().setValue("HEAD");
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        GitCurrentBranchConsumer cbConsumer = new GitCurrentBranchConsumer(logger);
        int exitCode = GitCommandLineUtils.execute(cl, (StreamConsumer)cbConsumer, stderr, logger);
        if (exitCode != 0) {
            throw new ScmException("Detecting the current branch failed: " + stderr.getOutput());
        }
        return cbConsumer.getBranchName();
    }
}

