/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer.checker;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import org.jetbrains.kotlin.backend.common.actualizer.checker.IrExpectActualChecker;
import org.jetbrains.kotlin.backend.common.actualizer.checker.IrExpectActualCheckersUtilsKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.mpp.DeclarationSymbolMarker;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualAnnotationMatchChecker;
import org.jetbrains.kotlin.resolve.calls.mpp.ExpectActualMatchingContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\nH\u0002R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/checker/IrExpectActualAnnotationMatchingChecker;", "Lorg/jetbrains/kotlin/backend/common/actualizer/checker/IrExpectActualChecker;", "<init>", "()V", "check", "", "context", "Lorg/jetbrains/kotlin/backend/common/actualizer/checker/IrExpectActualChecker$Context;", "isFakeOverride", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)Z", "getContainingActualClassIfFakeOverride", "actualSymbol", "ir.actualization"})
public final class IrExpectActualAnnotationMatchingChecker
implements IrExpectActualChecker {
    @NotNull
    public static final IrExpectActualAnnotationMatchingChecker INSTANCE = new IrExpectActualAnnotationMatchingChecker();

    private IrExpectActualAnnotationMatchingChecker() {
    }

    @Override
    public void check(@NotNull IrExpectActualChecker.Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrExpectActualChecker.Context $this$check_u24lambda_u241 = context2;
        boolean bl = false;
        if (!$this$check_u24lambda_u241.getDiagnosticsReporter().getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            return;
        }
        for (Map.Entry<IrSymbol, IrSymbol> entry : $this$check_u24lambda_u241.getMatchedExpectToActual().entrySet()) {
            AbstractExpectActualAnnotationMatchChecker.Incompatibility incompatibility;
            IrSymbol irSymbol2;
            IrSymbol expectSymbol = entry.getKey();
            IrSymbol actualSymbol = entry.getValue();
            if (expectSymbol instanceof IrTypeParameterSymbol || AbstractExpectActualAnnotationMatchChecker.INSTANCE.areAnnotationsCompatible(expectSymbol, (DeclarationSymbolMarker)actualSymbol, null, $this$check_u24lambda_u241.getMatchingContext()) == null) continue;
            IrSymbolOwner irSymbolOwner = expectSymbol.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            IrTypeAliasSymbol irTypeAliasSymbol = IrExpectActualCheckersUtilsKt.getTypealiasSymbolIfActualizedViaTypealias((IrDeclaration)irSymbolOwner, $this$check_u24lambda_u241.getClassActualizationInfo());
            if (irTypeAliasSymbol != null) {
                irSymbol2 = irTypeAliasSymbol;
            } else {
                irSymbol2 = INSTANCE.getContainingActualClassIfFakeOverride(actualSymbol);
                if (irSymbol2 == null) {
                    irSymbol2 = actualSymbol;
                }
            }
            IrSymbol reportOn = irSymbol2;
            IrDiagnosticReporter irDiagnosticReporter = $this$check_u24lambda_u241.getDiagnosticsReporter();
            DeclarationSymbolMarker declarationSymbolMarker = incompatibility.getExpectSymbol();
            Intrinsics.checkNotNull((Object)declarationSymbolMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrSymbol");
            IrSymbol irSymbol3 = (IrSymbol)declarationSymbolMarker;
            DeclarationSymbolMarker declarationSymbolMarker2 = incompatibility.getActualSymbol();
            Intrinsics.checkNotNull((Object)declarationSymbolMarker2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrSymbol");
            IrActualizerUtilsKt.reportActualAnnotationsNotMatchExpect(irDiagnosticReporter, irSymbol3, (IrSymbol)declarationSymbolMarker2, incompatibility.getType().mapAnnotationType(IrExpectActualAnnotationMatchingChecker::check$lambda$1$lambda$0), reportOn);
        }
    }

    private final boolean isFakeOverride(IrSymbol $this$isFakeOverride) {
        IrSymbolOwner irSymbolOwner = $this$isFakeOverride.getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        return IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)irSymbolOwner);
    }

    private final IrSymbol getContainingActualClassIfFakeOverride(IrSymbol actualSymbol) {
        if (!this.isFakeOverride(actualSymbol)) {
            return null;
        }
        IrSymbolOwner irSymbolOwner = actualSymbol.getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        IrClass irClass = IrExpectActualCheckersUtilsKt.getContainingTopLevelClass((IrDeclaration)irSymbolOwner);
        return irClass != null ? irClass.getSymbol() : null;
    }

    private static final IrConstructorCall check$lambda$1$lambda$0(ExpectActualMatchingContext.AnnotationCallInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getAnnotationSymbol();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConstructorCall");
        return (IrConstructorCall)object;
    }
}

