/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeNotFunctionAsOperator;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConventionFunctionCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkNotFunctionAsOperator", "callExpression", "receiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConventionFunctionCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConventionFunctionCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConventionFunctionCallChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,72:1\n20#2,2:73\n*S KotlinDebug\n*F\n+ 1 FirConventionFunctionCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConventionFunctionCallChecker\n*L\n54#1:73,2\n*E\n"})
public final class FirConventionFunctionCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirConventionFunctionCallChecker INSTANCE = new FirConventionFunctionCallChecker();

    private FirConventionFunctionCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkNotFunctionAsOperator(expression2, expression2.getDispatchReceiver(), context2, reporter);
        this.checkNotFunctionAsOperator(expression2, expression2.getExtensionReceiver(), context2, reporter);
        Object object = expression2.getCalleeReference();
        FirErrorNamedReference firErrorNamedReference = object instanceof FirErrorNamedReference ? (FirErrorNamedReference)object : null;
        if (firErrorNamedReference == null) {
            return;
        }
        FirErrorNamedReference calleeReference = firErrorNamedReference;
        ConeDiagnostic coneDiagnostic = calleeReference.getDiagnostic();
        ConeUnresolvedNameError coneUnresolvedNameError = coneDiagnostic instanceof ConeUnresolvedNameError ? (ConeUnresolvedNameError)coneDiagnostic : null;
        if (coneUnresolvedNameError == null) {
            return;
        }
        ConeUnresolvedNameError diagnostic = coneUnresolvedNameError;
        KtSourceElement ktSourceElement = expression2.getCalleeReference().getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE)) {
            object = diagnostic.getName();
            if (Intrinsics.areEqual((Object)object, (Object)OperatorNameConventions.GET)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)calleeReference.getSource(), FirErrors.INSTANCE.getNO_GET_METHOD(), (DiagnosticContext)context2, null, 8, null);
            } else if (Intrinsics.areEqual((Object)object, (Object)OperatorNameConventions.SET)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)calleeReference.getSource(), FirErrors.INSTANCE.getNO_SET_METHOD(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkNotFunctionAsOperator(FirFunctionCall callExpression, FirExpression receiver, CheckerContext context2, DiagnosticReporter reporter) {
        Object object;
        Object v3;
        FirExpression unwrapped;
        block10: {
            List<ConeDiagnostic> list;
            FirExpression firExpression = callExpression.getDispatchReceiver();
            if ((firExpression != null ? FirTypeUtilsKt.getResolvedType(firExpression) : null) instanceof ConeDynamicType) {
                return;
            }
            FirExpression firExpression2 = receiver;
            if (firExpression2 == null || (firExpression2 = FirExpressionUtilKt.unwrapSmartcastExpression(firExpression2)) == null) {
                return;
            }
            unwrapped = firExpression2;
            FirExpression firExpression3 = unwrapped;
            if (firExpression3 instanceof FirQualifiedAccessExpression) {
                list = ((FirQualifiedAccessExpression)unwrapped).getNonFatalDiagnostics();
            } else if (firExpression3 instanceof FirResolvedQualifier) {
                list = ((FirResolvedQualifier)unwrapped).getNonFatalDiagnostics();
            } else {
                return;
            }
            List<ConeDiagnostic> nonFatalDiagnostics = list;
            Iterable $this$firstIsInstanceOrNull$iv = nonFatalDiagnostics;
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof ConeNotFunctionAsOperator)) continue;
                v3 = element$iv;
                break block10;
            }
            v3 = null;
        }
        if ((object = (ConeNotFunctionAsOperator)v3) == null || (object = ((ConeNotFunctionAsOperator)object).getSymbol()) == null) {
            return;
        }
        Object diagnosticSymbol = object;
        ClassId classId = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getResolvedType(unwrapped));
        Intrinsics.checkNotNull((Object)classId);
        if (Intrinsics.areEqual((Object)classId.getShortClassName(), (Object)OperatorNameConventions.ITERATOR)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unwrapped.getSource(), FirErrors.INSTANCE.getITERATOR_MISSING(), (DiagnosticContext)context2, null, 8, null);
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)callExpression.getCalleeReference().getSource(), FirErrors.INSTANCE.getNOT_FUNCTION_AS_OPERATOR(), (Object)(diagnosticSymbol instanceof FirPropertySymbol ? "Property" : "Object"), diagnosticSymbol, (DiagnosticContext)context2, null, 32, null);
        }
    }
}

