/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/EnumIntrinsicsUtils;", "", "<init>", "()V", "transformEnumTopLevelIntrinsic", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "staticMethodPredicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "", "transformEnumValueOfIntrinsic", "transformEnumValuesIntrinsic", "transformEnumEntriesIntrinsic", "backend.js"})
@SourceDebugExtension(value={"SMAP\nEnumIntrinsicsTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumIntrinsicsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/lower/calls/EnumIntrinsicsUtils\n+ 2 IrUtils.kt\norg/jetbrains/kotlin/ir/util/IrUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n478#2:63\n1#3:64\n*S KotlinDebug\n*F\n+ 1 EnumIntrinsicsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/lower/calls/EnumIntrinsicsUtils\n*L\n29#1:63\n29#1:64\n*E\n"})
public final class EnumIntrinsicsUtils {
    @NotNull
    public static final EnumIntrinsicsUtils INSTANCE = new EnumIntrinsicsUtils();

    private EnumIntrinsicsUtils() {
    }

    private final IrExpression transformEnumTopLevelIntrinsic(IrFunctionAccessExpression call2, Function1<? super IrSimpleFunction, Boolean> staticMethodPredicate) {
        IrSimpleFunction staticMethod;
        Object v2;
        Object v1;
        block5: {
            IrAnnotationContainer irAnnotationContainer = call2.getTypeArgument(0);
            if (irAnnotationContainer == null || (irAnnotationContainer = IrTypesKt.getClass(irAnnotationContainer)) == null) {
                return call2;
            }
            IrAnnotationContainer irAnnotationContainer2 = irAnnotationContainer;
            if (!IrUtilsKt.isEnumClass((IrClass)irAnnotationContainer2)) {
                return call2;
            }
            IrDeclarationContainer $this$findDeclaration$iv = (IrDeclarationContainer)((Object)irAnnotationContainer2);
            boolean $i$f$findDeclaration = false;
            for (Object t : (Iterable)$this$findDeclaration$iv.getDeclarations()) {
                IrDeclaration it$iv = (IrDeclaration)t;
                boolean bl = false;
                if (!(it$iv instanceof IrSimpleFunction && (Boolean)staticMethodPredicate.invoke((Object)it$iv) != false)) continue;
                v1 = t;
                break block5;
            }
            v1 = v2 = null;
        }
        if (!(v1 instanceof IrSimpleFunction)) {
            v2 = null;
        }
        if ((staticMethod = (IrSimpleFunction)((IrDeclaration)v2)) == null || !IrDeclarationsKt.isStaticMethodOfClass(staticMethod)) {
            CompilationExceptionKt.compilationException("Enum class should have static method for " + ((IrFunctionSymbol)call2.getSymbol()).getOwner().getName(), call2);
            throw null;
        }
        return IrUtilsKt.irCall$default(call2, staticMethod.getSymbol(), false, false, null, null, 60, null);
    }

    @NotNull
    public final IrExpression transformEnumValueOfIntrinsic(@NotNull IrFunctionAccessExpression call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        return this.transformEnumTopLevelIntrinsic(call2, (Function1<? super IrSimpleFunction, Boolean>)((Function1)EnumIntrinsicsUtils::transformEnumValueOfIntrinsic$lambda$0));
    }

    @NotNull
    public final IrExpression transformEnumValuesIntrinsic(@NotNull IrFunctionAccessExpression call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        return this.transformEnumTopLevelIntrinsic(call2, (Function1<? super IrSimpleFunction, Boolean>)((Function1)EnumIntrinsicsUtils::transformEnumValuesIntrinsic$lambda$1));
    }

    @NotNull
    public final IrExpression transformEnumEntriesIntrinsic(@NotNull IrFunctionAccessExpression call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        return this.transformEnumTopLevelIntrinsic(call2, (Function1<? super IrSimpleFunction, Boolean>)((Function1)EnumIntrinsicsUtils::transformEnumEntriesIntrinsic$lambda$2));
    }

    private static final boolean transformEnumValueOfIntrinsic$lambda$0(IrSimpleFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)Name.identifier("valueOf")) && ((Collection)it.getValueParameters()).size() == 1 && IrTypePredicatesKt.isString(it.getValueParameters().get(0).getType());
    }

    private static final boolean transformEnumValuesIntrinsic$lambda$1(IrSimpleFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)Name.identifier("values")) && ((Collection)it.getValueParameters()).size() == 0;
    }

    private static final boolean transformEnumEntriesIntrinsic$lambda$2(IrSimpleFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)Name.special("<get-entries>"));
    }
}

