/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.load.kotlin.JvmType;
import org.jetbrains.kotlin.load.kotlin.JvmTypeFactory;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0014\u0010\u0012\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactoryImpl;", "Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactory;", "Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "<init>", "()V", "boxType", "possiblyPrimitiveType", "createFromString", "representation", "", "createPrimitiveType", "primitiveType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "createObjectType", "Lorg/jetbrains/kotlin/load/kotlin/JvmType$Object;", "internalName", "toString", "type", "javaLangClassType", "getJavaLangClassType", "()Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "descriptors.jvm"})
@SourceDebugExtension(value={"SMAP\nmethodSignatureMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 methodSignatureMapping.kt\norg/jetbrains/kotlin/load/kotlin/JvmTypeFactoryImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,200:1\n1#2:201\n1310#3,2:202\n*S KotlinDebug\n*F\n+ 1 methodSignatureMapping.kt\norg/jetbrains/kotlin/load/kotlin/JvmTypeFactoryImpl\n*L\n144#1:202,2\n*E\n"})
final class JvmTypeFactoryImpl
implements JvmTypeFactory<JvmType> {
    @NotNull
    public static final JvmTypeFactoryImpl INSTANCE = new JvmTypeFactoryImpl();

    private JvmTypeFactoryImpl() {
    }

    @Override
    @NotNull
    public JvmType boxType(@NotNull JvmType possiblyPrimitiveType) {
        JvmType jvmType;
        Intrinsics.checkNotNullParameter((Object)possiblyPrimitiveType, (String)"possiblyPrimitiveType");
        if (possiblyPrimitiveType instanceof JvmType.Primitive && ((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType() != null) {
            String string2 = JvmClassName.byFqNameWithoutInnerClasses(((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType().getWrapperFqName()).getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInternalName(...)");
            jvmType = this.createObjectType(string2);
        } else {
            jvmType = possiblyPrimitiveType;
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType createFromString(@NotNull String representation) {
        JvmType jvmType;
        JvmPrimitiveType jvmPrimitiveType;
        char firstChar;
        block8: {
            JvmPrimitiveType jvmPrimitiveType2;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)representation, (String)"representation");
            boolean bl2 = bl = ((CharSequence)representation).length() > 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "empty string as JvmType";
                throw new AssertionError((Object)string2);
            }
            firstChar = representation.charAt(0);
            JvmPrimitiveType[] $this$firstOrNull$iv = JvmPrimitiveType.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                JvmPrimitiveType element$iv;
                JvmPrimitiveType it = element$iv = $this$firstOrNull$iv[i];
                boolean bl4 = false;
                if (!(it.getDesc().charAt(0) == firstChar)) continue;
                jvmPrimitiveType2 = element$iv;
                break block8;
            }
            jvmPrimitiveType2 = jvmPrimitiveType = null;
        }
        if (jvmPrimitiveType != null) {
            JvmPrimitiveType it = jvmPrimitiveType;
            boolean bl = false;
            return new JvmType.Primitive(it);
        }
        char c = firstChar;
        if (c == 'V') {
            jvmType = new JvmType.Primitive(null);
        } else if (c == '[') {
            String string3 = representation.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            jvmType = new JvmType.Array(this.createFromString(string3));
        } else {
            boolean bl;
            boolean bl5 = bl = firstChar == 'L' && StringsKt.endsWith$default((CharSequence)representation, (char)';', (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                boolean bl6 = false;
                String string4 = "Type that is not primitive nor array should be Object, but '" + representation + "' was found";
                throw new AssertionError((Object)string4);
            }
            String string5 = representation.substring(1, representation.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            jvmType = new JvmType.Object(string5);
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType createPrimitiveType(@NotNull PrimitiveType primitiveType) {
        JvmType jvmType;
        Intrinsics.checkNotNullParameter((Object)((Object)primitiveType), (String)"primitiveType");
        switch (WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
            case 1: {
                jvmType = JvmType.Companion.getBOOLEAN$descriptors_jvm();
                break;
            }
            case 2: {
                jvmType = JvmType.Companion.getCHAR$descriptors_jvm();
                break;
            }
            case 3: {
                jvmType = JvmType.Companion.getBYTE$descriptors_jvm();
                break;
            }
            case 4: {
                jvmType = JvmType.Companion.getSHORT$descriptors_jvm();
                break;
            }
            case 5: {
                jvmType = JvmType.Companion.getINT$descriptors_jvm();
                break;
            }
            case 6: {
                jvmType = JvmType.Companion.getFLOAT$descriptors_jvm();
                break;
            }
            case 7: {
                jvmType = JvmType.Companion.getLONG$descriptors_jvm();
                break;
            }
            case 8: {
                jvmType = JvmType.Companion.getDOUBLE$descriptors_jvm();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType.Object createObjectType(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        return new JvmType.Object(internalName);
    }

    @Override
    @NotNull
    public String toString(@NotNull JvmType type2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        JvmType jvmType = type2;
        if (jvmType instanceof JvmType.Array) {
            object = '[' + this.toString(((JvmType.Array)type2).getElementType());
        } else if (jvmType instanceof JvmType.Primitive) {
            object = ((JvmType.Primitive)type2).getJvmPrimitiveType();
            if (object == null || (object = object.getDesc()) == null) {
                object = "V";
            }
        } else if (jvmType instanceof JvmType.Object) {
            object = 'L' + ((JvmType.Object)type2).getInternalName() + ';';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Override
    @NotNull
    public JvmType getJavaLangClassType() {
        return this.createObjectType("java/lang/Class");
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            try {
                nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.BYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.INT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.LONG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

