/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.diff;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.util.AbstractConsumer;

public class GitDiffRawConsumer
extends AbstractConsumer {
    private final List<ScmFile> changedFiles = new ArrayList<ScmFile>();

    public void consumeLine(String line) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        if (line == null || line.isEmpty()) {
            return;
        }
        ScmFileStatus status = null;
        String[] parts = line.split("\\s", 6);
        if (parts.length != 6) {
            this.logger.warn("Skipping line because it doesn't contain the right status parameters: " + line);
            return;
        }
        String modus = parts[4];
        String file = parts[5];
        if ("A".equals(modus)) {
            status = ScmFileStatus.ADDED;
        } else if ("M".equals(modus)) {
            status = ScmFileStatus.UPDATED;
        } else if ("D".equals(modus)) {
            status = ScmFileStatus.DELETED;
        } else {
            this.logger.warn("unknown status detected in line: " + line);
            return;
        }
        this.changedFiles.add(new ScmFile(file, status));
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }
}

